// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.AppContainers.Models
{
    /// <summary> Used to map workload profile types to billing meter. </summary>
    [EditorBrowsable(EditorBrowsableState.Never)]
    public readonly partial struct ContainerAppBillingMeterCategory : IEquatable<ContainerAppBillingMeterCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerAppBillingMeterCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerAppBillingMeterCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PremiumSkuGeneralPurposeValue = "PremiumSkuGeneralPurpose";
        private const string PremiumSkuMemoryOptimizedValue = "PremiumSkuMemoryOptimized";
        private const string PremiumSkuComputeOptimizedValue = "PremiumSkuComputeOptimized";

        /// <summary> PremiumSkuGeneralPurpose. </summary>
        public static ContainerAppBillingMeterCategory PremiumSkuGeneralPurpose { get; } = new ContainerAppBillingMeterCategory(PremiumSkuGeneralPurposeValue);
        /// <summary> PremiumSkuMemoryOptimized. </summary>
        public static ContainerAppBillingMeterCategory PremiumSkuMemoryOptimized { get; } = new ContainerAppBillingMeterCategory(PremiumSkuMemoryOptimizedValue);
        /// <summary> PremiumSkuComputeOptimized. </summary>
        public static ContainerAppBillingMeterCategory PremiumSkuComputeOptimized { get; } = new ContainerAppBillingMeterCategory(PremiumSkuComputeOptimizedValue);
        /// <summary> Determines if two <see cref="ContainerAppBillingMeterCategory"/> values are the same. </summary>
        public static bool operator ==(ContainerAppBillingMeterCategory left, ContainerAppBillingMeterCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerAppBillingMeterCategory"/> values are not the same. </summary>
        public static bool operator !=(ContainerAppBillingMeterCategory left, ContainerAppBillingMeterCategory right) => !left.Equals(right);
        /// <summary> Converts a string to a <see cref="ContainerAppBillingMeterCategory"/>. </summary>
        public static implicit operator ContainerAppBillingMeterCategory(string value) => new ContainerAppBillingMeterCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerAppBillingMeterCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerAppBillingMeterCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value?.GetHashCode() ?? 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
