// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.AppContainers.Samples
{
    public partial class Sample_ContainerAppRevisionResource
    {
        // Get Container App's revision
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetContainerAppSRevision()
        {
            // Generated from example definition: specification/app/resource-manager/Microsoft.App/stable/2024-03-01/examples/Revisions_Get.json
            // this example is just showing the usage of "ContainerAppsRevisions_GetRevision" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerAppRevisionResource created on azure
            // for more information of creating ContainerAppRevisionResource, please refer to the document of ContainerAppRevisionResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "rg";
            string containerAppName = "testcontainerApp0";
            string revisionName = "testcontainerApp0-pjxhsye";
            ResourceIdentifier containerAppRevisionResourceId = ContainerAppRevisionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, containerAppName, revisionName);
            ContainerAppRevisionResource containerAppRevision = client.GetContainerAppRevisionResource(containerAppRevisionResourceId);

            // invoke the operation
            ContainerAppRevisionResource result = await containerAppRevision.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerAppRevisionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Activate Container App's revision
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task ActivateRevision_ActivateContainerAppSRevision()
        {
            // Generated from example definition: specification/app/resource-manager/Microsoft.App/stable/2024-03-01/examples/Revisions_Activate.json
            // this example is just showing the usage of "ContainerAppsRevisions_ActivateRevision" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerAppRevisionResource created on azure
            // for more information of creating ContainerAppRevisionResource, please refer to the document of ContainerAppRevisionResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "rg";
            string containerAppName = "testcontainerApp0";
            string revisionName = "testcontainerApp0-pjxhsye";
            ResourceIdentifier containerAppRevisionResourceId = ContainerAppRevisionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, containerAppName, revisionName);
            ContainerAppRevisionResource containerAppRevision = client.GetContainerAppRevisionResource(containerAppRevisionResourceId);

            // invoke the operation
            await containerAppRevision.ActivateRevisionAsync();

            Console.WriteLine($"Succeeded");
        }

        // Deactivate Container App's revision
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task DeactivateRevision_DeactivateContainerAppSRevision()
        {
            // Generated from example definition: specification/app/resource-manager/Microsoft.App/stable/2024-03-01/examples/Revisions_Deactivate.json
            // this example is just showing the usage of "ContainerAppsRevisions_DeactivateRevision" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerAppRevisionResource created on azure
            // for more information of creating ContainerAppRevisionResource, please refer to the document of ContainerAppRevisionResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "rg";
            string containerAppName = "testcontainerApp0";
            string revisionName = "testcontainerApp0-pjxhsye";
            ResourceIdentifier containerAppRevisionResourceId = ContainerAppRevisionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, containerAppName, revisionName);
            ContainerAppRevisionResource containerAppRevision = client.GetContainerAppRevisionResource(containerAppRevisionResourceId);

            // invoke the operation
            await containerAppRevision.DeactivateRevisionAsync();

            Console.WriteLine($"Succeeded");
        }

        // Restart Container App's revision
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RestartRevision_RestartContainerAppSRevision()
        {
            // Generated from example definition: specification/app/resource-manager/Microsoft.App/stable/2024-03-01/examples/Revisions_Restart.json
            // this example is just showing the usage of "ContainerAppsRevisions_RestartRevision" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerAppRevisionResource created on azure
            // for more information of creating ContainerAppRevisionResource, please refer to the document of ContainerAppRevisionResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "rg";
            string containerAppName = "testStaticSite0";
            string revisionName = "testcontainerApp0-pjxhsye";
            ResourceIdentifier containerAppRevisionResourceId = ContainerAppRevisionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, containerAppName, revisionName);
            ContainerAppRevisionResource containerAppRevision = client.GetContainerAppRevisionResource(containerAppRevisionResourceId);

            // invoke the operation
            await containerAppRevision.RestartRevisionAsync();

            Console.WriteLine($"Succeeded");
        }
    }
}
