// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.AppContainers.Samples
{
    public partial class Sample_ContainerAppManagedEnvironmentDetectorResourcePropertyResource
    {
        // Get environments by name
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetEnvironmentsByName()
        {
            // Generated from example definition: specification/app/resource-manager/Microsoft.App/stable/2024-03-01/examples/ManagedEnvironments_Get.json
            // this example is just showing the usage of "ManagedEnvironmentsDiagnostics_GetRoot" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerAppManagedEnvironmentDetectorResourcePropertyResource created on azure
            // for more information of creating ContainerAppManagedEnvironmentDetectorResourcePropertyResource, please refer to the document of ContainerAppManagedEnvironmentDetectorResourcePropertyResource
            string subscriptionId = "8efdecc5-919e-44eb-b179-915dca89ebf9";
            string resourceGroupName = "examplerg";
            string environmentName = "jlaw-demo1";
            ResourceIdentifier containerAppManagedEnvironmentDetectorResourcePropertyResourceId = ContainerAppManagedEnvironmentDetectorResourcePropertyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, environmentName);
            ContainerAppManagedEnvironmentDetectorResourcePropertyResource containerAppManagedEnvironmentDetectorResourceProperty = client.GetContainerAppManagedEnvironmentDetectorResourcePropertyResource(containerAppManagedEnvironmentDetectorResourcePropertyResourceId);

            // invoke the operation
            ContainerAppManagedEnvironmentDetectorResourcePropertyResource result = await containerAppManagedEnvironmentDetectorResourceProperty.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerAppManagedEnvironmentData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
