// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.AppContainers.Samples
{
    public partial class Sample_ContainerAppJobExecutionResource
    {
        // Terminate a Container Apps Job
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task StopExecutionJob_TerminateAContainerAppsJob()
        {
            // Generated from example definition: specification/app/resource-manager/Microsoft.App/stable/2024-03-01/examples/Job_Stop_Execution.json
            // this example is just showing the usage of "Jobs_StopExecution" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerAppJobExecutionResource created on azure
            // for more information of creating ContainerAppJobExecutionResource, please refer to the document of ContainerAppJobExecutionResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "rg";
            string jobName = "testcontainerappsjob0";
            string jobExecutionName = "jobExecution1";
            ResourceIdentifier containerAppJobExecutionResourceId = ContainerAppJobExecutionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, jobExecutionName);
            ContainerAppJobExecutionResource containerAppJobExecution = client.GetContainerAppJobExecutionResource(containerAppJobExecutionResourceId);

            // invoke the operation
            await containerAppJobExecution.StopExecutionJobAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get a single Job Execution
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetASingleJobExecution()
        {
            // Generated from example definition: specification/app/resource-manager/Microsoft.App/stable/2024-03-01/examples/Job_Execution_Get.json
            // this example is just showing the usage of "JobExecution" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerAppJobExecutionResource created on azure
            // for more information of creating ContainerAppJobExecutionResource, please refer to the document of ContainerAppJobExecutionResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "rg";
            string jobName = "testcontainerappsjob0";
            string jobExecutionName = "jobExecution1";
            ResourceIdentifier containerAppJobExecutionResourceId = ContainerAppJobExecutionResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, jobExecutionName);
            ContainerAppJobExecutionResource containerAppJobExecution = client.GetContainerAppJobExecutionResource(containerAppJobExecutionResourceId);

            // invoke the operation
            ContainerAppJobExecutionResource result = await containerAppJobExecution.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerAppJobExecutionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List all operations
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetCustomDomainVerificationId_ListAllOperations()
        {
            // Generated from example definition: specification/app/resource-manager/Microsoft.App/stable/2024-03-01/examples/Subscriptions_GetCustomDomainVerificationId.json
            // this example is just showing the usage of "GetCustomDomainVerificationId" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "d27c3573-f76e-4b26-b871-0ccd2203d08c";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation
            string result = await subscriptionResource.GetCustomDomainVerificationIdAsync();

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
