// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.AppContainers.Samples
{
    public partial class Sample_ContainerAppJobDetectorPropertyResource
    {
        // Get Container App Job by name
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetContainerAppJobByName()
        {
            // Generated from example definition: specification/app/resource-manager/Microsoft.App/stable/2024-03-01/examples/Job_ProxyGet.json
            // this example is just showing the usage of "Jobs_ProxyGet" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ContainerAppJobDetectorPropertyResource created on azure
            // for more information of creating ContainerAppJobDetectorPropertyResource, please refer to the document of ContainerAppJobDetectorPropertyResource
            string subscriptionId = "34adfa4f-cedf-4dc0-ba29-b6d1a69ab345";
            string resourceGroupName = "rg";
            string jobName = "testcontainerappsjob0";
            string apiName = "rootApi";
            ResourceIdentifier containerAppJobDetectorPropertyResourceId = ContainerAppJobDetectorPropertyResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, jobName, apiName);
            ContainerAppJobDetectorPropertyResource containerAppJobDetectorProperty = client.GetContainerAppJobDetectorPropertyResource(containerAppJobDetectorPropertyResourceId);

            // invoke the operation
            ContainerAppJobDetectorPropertyResource result = await containerAppJobDetectorProperty.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ContainerAppJobData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
