// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> Specifies the kind of usage details. </summary>
    internal readonly partial struct UsageDetailsKind : IEquatable<UsageDetailsKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UsageDetailsKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UsageDetailsKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LegacyValue = "legacy";
        private const string ModernValue = "modern";

        /// <summary> legacy. </summary>
        public static UsageDetailsKind Legacy { get; } = new UsageDetailsKind(LegacyValue);
        /// <summary> modern. </summary>
        public static UsageDetailsKind Modern { get; } = new UsageDetailsKind(ModernValue);
        /// <summary> Determines if two <see cref="UsageDetailsKind"/> values are the same. </summary>
        public static bool operator ==(UsageDetailsKind left, UsageDetailsKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UsageDetailsKind"/> values are not the same. </summary>
        public static bool operator !=(UsageDetailsKind left, UsageDetailsKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UsageDetailsKind"/>. </summary>
        public static implicit operator UsageDetailsKind(string value) => new UsageDetailsKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UsageDetailsKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UsageDetailsKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
