// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> Result of listing reservation recommendations. </summary>
    internal partial class ReservationRecommendationsListResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ReservationRecommendationsListResult"/>. </summary>
        internal ReservationRecommendationsListResult()
        {
            Value = new ChangeTrackingList<ConsumptionReservationRecommendation>();
        }

        /// <summary> Initializes a new instance of <see cref="ReservationRecommendationsListResult"/>. </summary>
        /// <param name="value">
        /// The list of reservation recommendations.
        /// Please note <see cref="ConsumptionReservationRecommendation"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ConsumptionLegacyReservationRecommendation"/> and <see cref="ConsumptionModernReservationRecommendation"/>.
        /// </param>
        /// <param name="nextLink"> The link (url) to the next page of results. </param>
        /// <param name="previousLink"> The link (url) to the previous page of results. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ReservationRecommendationsListResult(IReadOnlyList<ConsumptionReservationRecommendation> value, string nextLink, string previousLink, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            NextLink = nextLink;
            PreviousLink = previousLink;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The list of reservation recommendations.
        /// Please note <see cref="ConsumptionReservationRecommendation"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="ConsumptionLegacyReservationRecommendation"/> and <see cref="ConsumptionModernReservationRecommendation"/>.
        /// </summary>
        public IReadOnlyList<ConsumptionReservationRecommendation> Value { get; }
        /// <summary> The link (url) to the next page of results. </summary>
        public string NextLink { get; }
        /// <summary> The link (url) to the previous page of results. </summary>
        public string PreviousLink { get; }
    }
}
