// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> Specifies the kind of reservation recommendation. </summary>
    internal readonly partial struct ReservationRecommendationKind : IEquatable<ReservationRecommendationKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReservationRecommendationKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReservationRecommendationKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LegacyValue = "legacy";
        private const string ModernValue = "modern";

        /// <summary> legacy. </summary>
        public static ReservationRecommendationKind Legacy { get; } = new ReservationRecommendationKind(LegacyValue);
        /// <summary> modern. </summary>
        public static ReservationRecommendationKind Modern { get; } = new ReservationRecommendationKind(ModernValue);
        /// <summary> Determines if two <see cref="ReservationRecommendationKind"/> values are the same. </summary>
        public static bool operator ==(ReservationRecommendationKind left, ReservationRecommendationKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReservationRecommendationKind"/> values are not the same. </summary>
        public static bool operator !=(ReservationRecommendationKind left, ReservationRecommendationKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReservationRecommendationKind"/>. </summary>
        public static implicit operator ReservationRecommendationKind(string value) => new ReservationRecommendationKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReservationRecommendationKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReservationRecommendationKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
