// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> The properties of the price sheet. </summary>
    public partial class PriceSheetProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PriceSheetProperties"/>. </summary>
        internal PriceSheetProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PriceSheetProperties"/>. </summary>
        /// <param name="billingPeriodId"> The id of the billing period resource that the usage belongs to. </param>
        /// <param name="meterId"> The meter id (GUID). </param>
        /// <param name="meterDetails"> The details about the meter. By default this is not populated, unless it's specified in $expand. </param>
        /// <param name="unitOfMeasure"> Unit of measure. </param>
        /// <param name="includedQuantity"> Included quality for an offer. </param>
        /// <param name="partNumber"> Part Number. </param>
        /// <param name="unitPrice"> Unit Price. </param>
        /// <param name="currencyCode"> Currency Code. </param>
        /// <param name="offerId"> Offer Id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PriceSheetProperties(ResourceIdentifier billingPeriodId, Guid? meterId, ConsumptionMeterDetails meterDetails, string unitOfMeasure, decimal? includedQuantity, string partNumber, decimal? unitPrice, string currencyCode, string offerId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BillingPeriodId = billingPeriodId;
            MeterId = meterId;
            MeterDetails = meterDetails;
            UnitOfMeasure = unitOfMeasure;
            IncludedQuantity = includedQuantity;
            PartNumber = partNumber;
            UnitPrice = unitPrice;
            CurrencyCode = currencyCode;
            OfferId = offerId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The id of the billing period resource that the usage belongs to. </summary>
        public ResourceIdentifier BillingPeriodId { get; }
        /// <summary> The meter id (GUID). </summary>
        public Guid? MeterId { get; }
        /// <summary> The details about the meter. By default this is not populated, unless it's specified in $expand. </summary>
        public ConsumptionMeterDetails MeterDetails { get; }
        /// <summary> Unit of measure. </summary>
        public string UnitOfMeasure { get; }
        /// <summary> Included quality for an offer. </summary>
        public decimal? IncludedQuantity { get; }
        /// <summary> Part Number. </summary>
        public string PartNumber { get; }
        /// <summary> Unit Price. </summary>
        public decimal? UnitPrice { get; }
        /// <summary> Currency Code. </summary>
        public string CurrencyCode { get; }
        /// <summary> Offer Id. </summary>
        public string OfferId { get; }
    }
}
