// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> The type of threshold. </summary>
    public readonly partial struct NotificationThresholdType : IEquatable<NotificationThresholdType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NotificationThresholdType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NotificationThresholdType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActualValue = "Actual";
        private const string ForecastedValue = "Forecasted";

        /// <summary> Actual costs budget alerts notify when the actual accrued cost exceeds the allocated budget . </summary>
        public static NotificationThresholdType Actual { get; } = new NotificationThresholdType(ActualValue);
        /// <summary> Forecasted costs budget alerts provide advanced notification that your spending trends are likely to exceed your allocated budget, as it relies on forecasted cost predictions. </summary>
        public static NotificationThresholdType Forecasted { get; } = new NotificationThresholdType(ForecastedValue);
        /// <summary> Determines if two <see cref="NotificationThresholdType"/> values are the same. </summary>
        public static bool operator ==(NotificationThresholdType left, NotificationThresholdType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NotificationThresholdType"/> values are not the same. </summary>
        public static bool operator !=(NotificationThresholdType left, NotificationThresholdType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NotificationThresholdType"/>. </summary>
        public static implicit operator NotificationThresholdType(string value) => new NotificationThresholdType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NotificationThresholdType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NotificationThresholdType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
