// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> The comparison operator. </summary>
    public readonly partial struct NotificationAlertTriggerType : IEquatable<NotificationAlertTriggerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NotificationAlertTriggerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NotificationAlertTriggerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EqualToValue = "EqualTo";
        private const string GreaterThanValue = "GreaterThan";
        private const string GreaterThanOrEqualToValue = "GreaterThanOrEqualTo";

        /// <summary> Alert will be triggered if the evaluated cost is the same as threshold value. Note: It’s not recommended to use this OperatorType as there’s low chance of cost being exactly the same as threshold value, leading to missing of your alert. This OperatorType will be deprecated in future. </summary>
        public static NotificationAlertTriggerType EqualTo { get; } = new NotificationAlertTriggerType(EqualToValue);
        /// <summary> Alert will be triggered if the evaluated cost is greater than the threshold value. Note: This is the recommended OperatorType while configuring Budget Alert. </summary>
        public static NotificationAlertTriggerType GreaterThan { get; } = new NotificationAlertTriggerType(GreaterThanValue);
        /// <summary> Alert will be triggered if the evaluated cost is greater than or equal to the threshold value. </summary>
        public static NotificationAlertTriggerType GreaterThanOrEqualTo { get; } = new NotificationAlertTriggerType(GreaterThanOrEqualToValue);
        /// <summary> Determines if two <see cref="NotificationAlertTriggerType"/> values are the same. </summary>
        public static bool operator ==(NotificationAlertTriggerType left, NotificationAlertTriggerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NotificationAlertTriggerType"/> values are not the same. </summary>
        public static bool operator !=(NotificationAlertTriggerType left, NotificationAlertTriggerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NotificationAlertTriggerType"/>. </summary>
        public static implicit operator NotificationAlertTriggerType(string value) => new NotificationAlertTriggerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NotificationAlertTriggerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NotificationAlertTriggerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
