// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Consumption.Models
{
    public partial class ConsumptionReservationSummary : IUtf8JsonSerializable, IJsonModel<ConsumptionReservationSummary>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConsumptionReservationSummary>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConsumptionReservationSummary>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionReservationSummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConsumptionReservationSummary)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("etag"u8);
                writer.WriteStringValue(ETag.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ReservationOrderId))
            {
                writer.WritePropertyName("reservationOrderId"u8);
                writer.WriteStringValue(ReservationOrderId);
            }
            if (options.Format != "W" && Optional.IsDefined(ReservationId))
            {
                writer.WritePropertyName("reservationId"u8);
                writer.WriteStringValue(ReservationId);
            }
            if (options.Format != "W" && Optional.IsDefined(SkuName))
            {
                writer.WritePropertyName("skuName"u8);
                writer.WriteStringValue(SkuName);
            }
            if (options.Format != "W" && Optional.IsDefined(ReservedHours))
            {
                writer.WritePropertyName("reservedHours"u8);
                writer.WriteNumberValue(ReservedHours.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(UseOn))
            {
                writer.WritePropertyName("usageDate"u8);
                writer.WriteStringValue(UseOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(UsedHours))
            {
                writer.WritePropertyName("usedHours"u8);
                writer.WriteNumberValue(UsedHours.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MinUtilizationPercentage))
            {
                writer.WritePropertyName("minUtilizationPercentage"u8);
                writer.WriteNumberValue(MinUtilizationPercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AvgUtilizationPercentage))
            {
                writer.WritePropertyName("avgUtilizationPercentage"u8);
                writer.WriteNumberValue(AvgUtilizationPercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MaxUtilizationPercentage))
            {
                writer.WritePropertyName("maxUtilizationPercentage"u8);
                writer.WriteNumberValue(MaxUtilizationPercentage.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Kind))
            {
                writer.WritePropertyName("kind"u8);
                writer.WriteStringValue(Kind);
            }
            if (options.Format != "W" && Optional.IsDefined(PurchasedQuantity))
            {
                writer.WritePropertyName("purchasedQuantity"u8);
                writer.WriteNumberValue(PurchasedQuantity.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(RemainingQuantity))
            {
                writer.WritePropertyName("remainingQuantity"u8);
                writer.WriteNumberValue(RemainingQuantity.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalReservedQuantity))
            {
                writer.WritePropertyName("totalReservedQuantity"u8);
                writer.WriteNumberValue(TotalReservedQuantity.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(UsedQuantity))
            {
                writer.WritePropertyName("usedQuantity"u8);
                writer.WriteNumberValue(UsedQuantity.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(UtilizedPercentage))
            {
                writer.WritePropertyName("utilizedPercentage"u8);
                writer.WriteNumberValue(UtilizedPercentage.Value);
            }
            writer.WriteEndObject();
        }

        ConsumptionReservationSummary IJsonModel<ConsumptionReservationSummary>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionReservationSummary>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConsumptionReservationSummary)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConsumptionReservationSummary(document.RootElement, options);
        }

        internal static ConsumptionReservationSummary DeserializeConsumptionReservationSummary(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ETag? etag = default;
            IReadOnlyDictionary<string, string> tags = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string reservationOrderId = default;
            string reservationId = default;
            string skuName = default;
            decimal? reservedHours = default;
            DateTimeOffset? usageDate = default;
            decimal? usedHours = default;
            decimal? minUtilizationPercentage = default;
            decimal? avgUtilizationPercentage = default;
            decimal? maxUtilizationPercentage = default;
            string kind = default;
            decimal? purchasedQuantity = default;
            decimal? remainingQuantity = default;
            decimal? totalReservedQuantity = default;
            decimal? usedQuantity = default;
            decimal? utilizedPercentage = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("etag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    etag = new ETag(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("reservationOrderId"u8))
                        {
                            reservationOrderId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("reservationId"u8))
                        {
                            reservationId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("skuName"u8))
                        {
                            skuName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("reservedHours"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            reservedHours = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("usageDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            usageDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("usedHours"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            usedHours = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("minUtilizationPercentage"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            minUtilizationPercentage = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("avgUtilizationPercentage"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            avgUtilizationPercentage = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("maxUtilizationPercentage"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            maxUtilizationPercentage = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("kind"u8))
                        {
                            kind = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("purchasedQuantity"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            purchasedQuantity = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("remainingQuantity"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            remainingQuantity = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("totalReservedQuantity"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            totalReservedQuantity = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("usedQuantity"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            usedQuantity = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("utilizedPercentage"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            utilizedPercentage = property0.Value.GetDecimal();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConsumptionReservationSummary(
                id,
                name,
                type,
                systemData,
                reservationOrderId,
                reservationId,
                skuName,
                reservedHours,
                usageDate,
                usedHours,
                minUtilizationPercentage,
                avgUtilizationPercentage,
                maxUtilizationPercentage,
                kind,
                purchasedQuantity,
                remainingQuantity,
                totalReservedQuantity,
                usedQuantity,
                utilizedPercentage,
                etag,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ConsumptionReservationSummary>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionReservationSummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConsumptionReservationSummary)} does not support writing '{options.Format}' format.");
            }
        }

        ConsumptionReservationSummary IPersistableModel<ConsumptionReservationSummary>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionReservationSummary>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConsumptionReservationSummary(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConsumptionReservationSummary)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConsumptionReservationSummary>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
