// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> The ConsumptionReservationRecommendationTerm. </summary>
    public readonly partial struct ConsumptionReservationRecommendationTerm : IEquatable<ConsumptionReservationRecommendationTerm>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConsumptionReservationRecommendationTerm"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConsumptionReservationRecommendationTerm(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string P1YValue = "P1Y";
        private const string P3YValue = "P3Y";

        /// <summary> 1 year reservation term. </summary>
        public static ConsumptionReservationRecommendationTerm P1Y { get; } = new ConsumptionReservationRecommendationTerm(P1YValue);
        /// <summary> 3 year reservation term. </summary>
        public static ConsumptionReservationRecommendationTerm P3Y { get; } = new ConsumptionReservationRecommendationTerm(P3YValue);
        /// <summary> Determines if two <see cref="ConsumptionReservationRecommendationTerm"/> values are the same. </summary>
        public static bool operator ==(ConsumptionReservationRecommendationTerm left, ConsumptionReservationRecommendationTerm right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConsumptionReservationRecommendationTerm"/> values are not the same. </summary>
        public static bool operator !=(ConsumptionReservationRecommendationTerm left, ConsumptionReservationRecommendationTerm right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConsumptionReservationRecommendationTerm"/>. </summary>
        public static implicit operator ConsumptionReservationRecommendationTerm(string value) => new ConsumptionReservationRecommendationTerm(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConsumptionReservationRecommendationTerm other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConsumptionReservationRecommendationTerm other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
