// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> The ConsumptionReservationRecommendationScope. </summary>
    public readonly partial struct ConsumptionReservationRecommendationScope : IEquatable<ConsumptionReservationRecommendationScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConsumptionReservationRecommendationScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConsumptionReservationRecommendationScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SingleValue = "Single";
        private const string SharedValue = "Shared";

        /// <summary> Single. </summary>
        public static ConsumptionReservationRecommendationScope Single { get; } = new ConsumptionReservationRecommendationScope(SingleValue);
        /// <summary> Shared. </summary>
        public static ConsumptionReservationRecommendationScope Shared { get; } = new ConsumptionReservationRecommendationScope(SharedValue);
        /// <summary> Determines if two <see cref="ConsumptionReservationRecommendationScope"/> values are the same. </summary>
        public static bool operator ==(ConsumptionReservationRecommendationScope left, ConsumptionReservationRecommendationScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConsumptionReservationRecommendationScope"/> values are not the same. </summary>
        public static bool operator !=(ConsumptionReservationRecommendationScope left, ConsumptionReservationRecommendationScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConsumptionReservationRecommendationScope"/>. </summary>
        public static implicit operator ConsumptionReservationRecommendationScope(string value) => new ConsumptionReservationRecommendationScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConsumptionReservationRecommendationScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConsumptionReservationRecommendationScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
