// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> The ConsumptionReservationRecommendationLookBackPeriod. </summary>
    public readonly partial struct ConsumptionReservationRecommendationLookBackPeriod : IEquatable<ConsumptionReservationRecommendationLookBackPeriod>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConsumptionReservationRecommendationLookBackPeriod"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConsumptionReservationRecommendationLookBackPeriod(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string Last07DaysValue = "Last7Days";
        private const string Last30DaysValue = "Last30Days";
        private const string Last60DaysValue = "Last60Days";

        /// <summary> Use 7 days of data for recommendations. </summary>
        public static ConsumptionReservationRecommendationLookBackPeriod Last07Days { get; } = new ConsumptionReservationRecommendationLookBackPeriod(Last07DaysValue);
        /// <summary> Use 30 days of data for recommendations. </summary>
        public static ConsumptionReservationRecommendationLookBackPeriod Last30Days { get; } = new ConsumptionReservationRecommendationLookBackPeriod(Last30DaysValue);
        /// <summary> Use 60 days of data for recommendations. </summary>
        public static ConsumptionReservationRecommendationLookBackPeriod Last60Days { get; } = new ConsumptionReservationRecommendationLookBackPeriod(Last60DaysValue);
        /// <summary> Determines if two <see cref="ConsumptionReservationRecommendationLookBackPeriod"/> values are the same. </summary>
        public static bool operator ==(ConsumptionReservationRecommendationLookBackPeriod left, ConsumptionReservationRecommendationLookBackPeriod right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConsumptionReservationRecommendationLookBackPeriod"/> values are not the same. </summary>
        public static bool operator !=(ConsumptionReservationRecommendationLookBackPeriod left, ConsumptionReservationRecommendationLookBackPeriod right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConsumptionReservationRecommendationLookBackPeriod"/>. </summary>
        public static implicit operator ConsumptionReservationRecommendationLookBackPeriod(string value) => new ConsumptionReservationRecommendationLookBackPeriod(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConsumptionReservationRecommendationLookBackPeriod other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConsumptionReservationRecommendationLookBackPeriod other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
