// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> The reseller properties. </summary>
    public partial class ConsumptionReseller
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConsumptionReseller"/>. </summary>
        internal ConsumptionReseller()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConsumptionReseller"/>. </summary>
        /// <param name="resellerId"> The reseller property ID. </param>
        /// <param name="resellerDescription"> The reseller property description. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConsumptionReseller(ResourceIdentifier resellerId, string resellerDescription, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ResellerId = resellerId;
            ResellerDescription = resellerDescription;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The reseller property ID. </summary>
        public ResourceIdentifier ResellerId { get; }
        /// <summary> The reseller property description. </summary>
        public string ResellerDescription { get; }
    }
}
