// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Consumption.Models
{
    public partial class ConsumptionModernUsageDetail : IUtf8JsonSerializable, IJsonModel<ConsumptionModernUsageDetail>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConsumptionModernUsageDetail>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConsumptionModernUsageDetail>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionModernUsageDetail>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConsumptionModernUsageDetail)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(BillingAccountId))
            {
                writer.WritePropertyName("billingAccountId"u8);
                writer.WriteStringValue(BillingAccountId);
            }
            if (options.Format != "W" && Optional.IsDefined(EffectivePrice))
            {
                writer.WritePropertyName("effectivePrice"u8);
                writer.WriteNumberValue(EffectivePrice.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(PricingModel))
            {
                writer.WritePropertyName("pricingModel"u8);
                writer.WriteStringValue(PricingModel.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(BillingAccountName))
            {
                writer.WritePropertyName("billingAccountName"u8);
                writer.WriteStringValue(BillingAccountName);
            }
            if (options.Format != "W" && Optional.IsDefined(BillingPeriodStartOn))
            {
                writer.WritePropertyName("billingPeriodStartDate"u8);
                writer.WriteStringValue(BillingPeriodStartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(BillingPeriodEndOn))
            {
                writer.WritePropertyName("billingPeriodEndDate"u8);
                writer.WriteStringValue(BillingPeriodEndOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(BillingProfileId))
            {
                writer.WritePropertyName("billingProfileId"u8);
                writer.WriteStringValue(BillingProfileId);
            }
            if (options.Format != "W" && Optional.IsDefined(BillingProfileName))
            {
                writer.WritePropertyName("billingProfileName"u8);
                writer.WriteStringValue(BillingProfileName);
            }
            if (options.Format != "W" && Optional.IsDefined(SubscriptionGuid))
            {
                writer.WritePropertyName("subscriptionGuid"u8);
                writer.WriteStringValue(SubscriptionGuid);
            }
            if (options.Format != "W" && Optional.IsDefined(SubscriptionName))
            {
                writer.WritePropertyName("subscriptionName"u8);
                writer.WriteStringValue(SubscriptionName);
            }
            if (options.Format != "W" && Optional.IsDefined(On))
            {
                writer.WritePropertyName("date"u8);
                writer.WriteStringValue(On.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(Product))
            {
                writer.WritePropertyName("product"u8);
                writer.WriteStringValue(Product);
            }
            if (options.Format != "W" && Optional.IsDefined(MeterId))
            {
                writer.WritePropertyName("meterId"u8);
                writer.WriteStringValue(MeterId.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MeterName))
            {
                writer.WritePropertyName("meterName"u8);
                writer.WriteStringValue(MeterName);
            }
            if (options.Format != "W" && Optional.IsDefined(MeterRegion))
            {
                writer.WritePropertyName("meterRegion"u8);
                writer.WriteStringValue(MeterRegion);
            }
            if (options.Format != "W" && Optional.IsDefined(MeterCategory))
            {
                writer.WritePropertyName("meterCategory"u8);
                writer.WriteStringValue(MeterCategory);
            }
            if (options.Format != "W" && Optional.IsDefined(MeterSubCategory))
            {
                writer.WritePropertyName("meterSubCategory"u8);
                writer.WriteStringValue(MeterSubCategory);
            }
            if (options.Format != "W" && Optional.IsDefined(ServiceFamily))
            {
                writer.WritePropertyName("serviceFamily"u8);
                writer.WriteStringValue(ServiceFamily);
            }
            if (options.Format != "W" && Optional.IsDefined(Quantity))
            {
                writer.WritePropertyName("quantity"u8);
                writer.WriteNumberValue(Quantity.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(UnitOfMeasure))
            {
                writer.WritePropertyName("unitOfMeasure"u8);
                writer.WriteStringValue(UnitOfMeasure);
            }
            if (options.Format != "W" && Optional.IsDefined(InstanceName))
            {
                writer.WritePropertyName("instanceName"u8);
                writer.WriteStringValue(InstanceName);
            }
            if (options.Format != "W" && Optional.IsDefined(CostInUSD))
            {
                writer.WritePropertyName("costInUSD"u8);
                writer.WriteNumberValue(CostInUSD.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(UnitPrice))
            {
                writer.WritePropertyName("unitPrice"u8);
                writer.WriteNumberValue(UnitPrice.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(BillingCurrencyCode))
            {
                writer.WritePropertyName("billingCurrencyCode"u8);
                writer.WriteStringValue(BillingCurrencyCode);
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceLocation))
            {
                writer.WritePropertyName("resourceLocation"u8);
                writer.WriteStringValue(ResourceLocation);
            }
            if (options.Format != "W" && Optional.IsDefined(ConsumedService))
            {
                writer.WritePropertyName("consumedService"u8);
                writer.WriteStringValue(ConsumedService);
            }
            if (options.Format != "W" && Optional.IsDefined(ServiceInfo1))
            {
                writer.WritePropertyName("serviceInfo1"u8);
                writer.WriteStringValue(ServiceInfo1);
            }
            if (options.Format != "W" && Optional.IsDefined(ServiceInfo2))
            {
                writer.WritePropertyName("serviceInfo2"u8);
                writer.WriteStringValue(ServiceInfo2);
            }
            if (options.Format != "W" && Optional.IsDefined(AdditionalInfo))
            {
                writer.WritePropertyName("additionalInfo"u8);
                writer.WriteStringValue(AdditionalInfo);
            }
            if (options.Format != "W" && Optional.IsDefined(InvoiceSectionId))
            {
                writer.WritePropertyName("invoiceSectionId"u8);
                writer.WriteStringValue(InvoiceSectionId);
            }
            if (options.Format != "W" && Optional.IsDefined(InvoiceSectionName))
            {
                writer.WritePropertyName("invoiceSectionName"u8);
                writer.WriteStringValue(InvoiceSectionName);
            }
            if (options.Format != "W" && Optional.IsDefined(CostCenter))
            {
                writer.WritePropertyName("costCenter"u8);
                writer.WriteStringValue(CostCenter);
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceGroup))
            {
                writer.WritePropertyName("resourceGroup"u8);
                writer.WriteStringValue(ResourceGroup);
            }
            if (options.Format != "W" && Optional.IsDefined(ReservationId))
            {
                writer.WritePropertyName("reservationId"u8);
                writer.WriteStringValue(ReservationId);
            }
            if (options.Format != "W" && Optional.IsDefined(ReservationName))
            {
                writer.WritePropertyName("reservationName"u8);
                writer.WriteStringValue(ReservationName);
            }
            if (options.Format != "W" && Optional.IsDefined(ProductOrderId))
            {
                writer.WritePropertyName("productOrderId"u8);
                writer.WriteStringValue(ProductOrderId);
            }
            if (options.Format != "W" && Optional.IsDefined(ProductOrderName))
            {
                writer.WritePropertyName("productOrderName"u8);
                writer.WriteStringValue(ProductOrderName);
            }
            if (options.Format != "W" && Optional.IsDefined(IsAzureCreditEligible))
            {
                writer.WritePropertyName("isAzureCreditEligible"u8);
                writer.WriteBooleanValue(IsAzureCreditEligible.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Term))
            {
                writer.WritePropertyName("term"u8);
                writer.WriteStringValue(Term);
            }
            if (options.Format != "W" && Optional.IsDefined(PublisherName))
            {
                writer.WritePropertyName("publisherName"u8);
                writer.WriteStringValue(PublisherName);
            }
            if (options.Format != "W" && Optional.IsDefined(PublisherType))
            {
                writer.WritePropertyName("publisherType"u8);
                writer.WriteStringValue(PublisherType);
            }
            if (options.Format != "W" && Optional.IsDefined(ChargeType))
            {
                writer.WritePropertyName("chargeType"u8);
                writer.WriteStringValue(ChargeType);
            }
            if (options.Format != "W" && Optional.IsDefined(Frequency))
            {
                writer.WritePropertyName("frequency"u8);
                writer.WriteStringValue(Frequency);
            }
            if (options.Format != "W" && Optional.IsDefined(CostInBillingCurrency))
            {
                writer.WritePropertyName("costInBillingCurrency"u8);
                writer.WriteNumberValue(CostInBillingCurrency.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CostInPricingCurrency))
            {
                writer.WritePropertyName("costInPricingCurrency"u8);
                writer.WriteNumberValue(CostInPricingCurrency.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ExchangeRate))
            {
                writer.WritePropertyName("exchangeRate"u8);
                writer.WriteStringValue(ExchangeRate);
            }
            if (options.Format != "W" && Optional.IsDefined(ExchangeRateOn))
            {
                writer.WritePropertyName("exchangeRateDate"u8);
                writer.WriteStringValue(ExchangeRateOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(InvoiceId))
            {
                writer.WritePropertyName("invoiceId"u8);
                writer.WriteStringValue(InvoiceId);
            }
            if (options.Format != "W" && Optional.IsDefined(PreviousInvoiceId))
            {
                writer.WritePropertyName("previousInvoiceId"u8);
                writer.WriteStringValue(PreviousInvoiceId);
            }
            if (options.Format != "W" && Optional.IsDefined(PricingCurrencyCode))
            {
                writer.WritePropertyName("pricingCurrencyCode"u8);
                writer.WriteStringValue(PricingCurrencyCode);
            }
            if (options.Format != "W" && Optional.IsDefined(ProductIdentifier))
            {
                writer.WritePropertyName("productIdentifier"u8);
                writer.WriteStringValue(ProductIdentifier);
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceLocationNormalized))
            {
                writer.WritePropertyName("resourceLocationNormalized"u8);
                writer.WriteStringValue(ResourceLocationNormalized);
            }
            if (options.Format != "W" && Optional.IsDefined(ServicePeriodStartOn))
            {
                writer.WritePropertyName("servicePeriodStartDate"u8);
                writer.WriteStringValue(ServicePeriodStartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ServicePeriodEndOn))
            {
                writer.WritePropertyName("servicePeriodEndDate"u8);
                writer.WriteStringValue(ServicePeriodEndOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(CustomerTenantId))
            {
                writer.WritePropertyName("customerTenantId"u8);
                writer.WriteStringValue(CustomerTenantId);
            }
            if (options.Format != "W" && Optional.IsDefined(CustomerName))
            {
                writer.WritePropertyName("customerName"u8);
                writer.WriteStringValue(CustomerName);
            }
            if (options.Format != "W" && Optional.IsDefined(PartnerTenantId))
            {
                writer.WritePropertyName("partnerTenantId"u8);
                writer.WriteStringValue(PartnerTenantId);
            }
            if (options.Format != "W" && Optional.IsDefined(PartnerName))
            {
                writer.WritePropertyName("partnerName"u8);
                writer.WriteStringValue(PartnerName);
            }
            if (options.Format != "W" && Optional.IsDefined(ResellerMpnId))
            {
                writer.WritePropertyName("resellerMpnId"u8);
                writer.WriteStringValue(ResellerMpnId);
            }
            if (options.Format != "W" && Optional.IsDefined(ResellerName))
            {
                writer.WritePropertyName("resellerName"u8);
                writer.WriteStringValue(ResellerName);
            }
            if (options.Format != "W" && Optional.IsDefined(PublisherId))
            {
                writer.WritePropertyName("publisherId"u8);
                writer.WriteStringValue(PublisherId);
            }
            if (options.Format != "W" && Optional.IsDefined(MarketPrice))
            {
                writer.WritePropertyName("marketPrice"u8);
                writer.WriteNumberValue(MarketPrice.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ExchangeRatePricingToBilling))
            {
                writer.WritePropertyName("exchangeRatePricingToBilling"u8);
                writer.WriteNumberValue(ExchangeRatePricingToBilling.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(PaygCostInBillingCurrency))
            {
                writer.WritePropertyName("paygCostInBillingCurrency"u8);
                writer.WriteNumberValue(PaygCostInBillingCurrency.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(PaygCostInUSD))
            {
                writer.WritePropertyName("paygCostInUSD"u8);
                writer.WriteNumberValue(PaygCostInUSD.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(PartnerEarnedCreditRate))
            {
                writer.WritePropertyName("partnerEarnedCreditRate"u8);
                writer.WriteNumberValue(PartnerEarnedCreditRate.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(PartnerEarnedCreditApplied))
            {
                writer.WritePropertyName("partnerEarnedCreditApplied"u8);
                writer.WriteStringValue(PartnerEarnedCreditApplied);
            }
            if (options.Format != "W" && Optional.IsDefined(PayGPrice))
            {
                writer.WritePropertyName("payGPrice"u8);
                writer.WriteNumberValue(PayGPrice.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(BenefitId))
            {
                writer.WritePropertyName("benefitId"u8);
                writer.WriteStringValue(BenefitId);
            }
            if (options.Format != "W" && Optional.IsDefined(BenefitName))
            {
                writer.WritePropertyName("benefitName"u8);
                writer.WriteStringValue(BenefitName);
            }
            if (options.Format != "W" && Optional.IsDefined(Provider))
            {
                writer.WritePropertyName("provider"u8);
                writer.WriteStringValue(Provider);
            }
            if (options.Format != "W" && Optional.IsDefined(CostAllocationRuleName))
            {
                writer.WritePropertyName("costAllocationRuleName"u8);
                writer.WriteStringValue(CostAllocationRuleName);
            }
            writer.WriteEndObject();
        }

        ConsumptionModernUsageDetail IJsonModel<ConsumptionModernUsageDetail>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionModernUsageDetail>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConsumptionModernUsageDetail)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConsumptionModernUsageDetail(document.RootElement, options);
        }

        internal static ConsumptionModernUsageDetail DeserializeConsumptionModernUsageDetail(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            UsageDetailsKind kind = default;
            ETag? etag = default;
            IReadOnlyDictionary<string, string> tags = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string billingAccountId = default;
            decimal? effectivePrice = default;
            ConsumptionPricingModelType? pricingModel = default;
            string billingAccountName = default;
            DateTimeOffset? billingPeriodStartDate = default;
            DateTimeOffset? billingPeriodEndDate = default;
            string billingProfileId = default;
            string billingProfileName = default;
            string subscriptionGuid = default;
            string subscriptionName = default;
            DateTimeOffset? date = default;
            string product = default;
            Guid? meterId = default;
            string meterName = default;
            string meterRegion = default;
            string meterCategory = default;
            string meterSubCategory = default;
            string serviceFamily = default;
            decimal? quantity = default;
            string unitOfMeasure = default;
            string instanceName = default;
            decimal? costInUSD = default;
            decimal? unitPrice = default;
            string billingCurrencyCode = default;
            string resourceLocation = default;
            string consumedService = default;
            string serviceInfo1 = default;
            string serviceInfo2 = default;
            string additionalInfo = default;
            string invoiceSectionId = default;
            string invoiceSectionName = default;
            string costCenter = default;
            string resourceGroup = default;
            string reservationId = default;
            string reservationName = default;
            string productOrderId = default;
            string productOrderName = default;
            bool? isAzureCreditEligible = default;
            string term = default;
            string publisherName = default;
            string publisherType = default;
            string chargeType = default;
            string frequency = default;
            decimal? costInBillingCurrency = default;
            decimal? costInPricingCurrency = default;
            string exchangeRate = default;
            DateTimeOffset? exchangeRateDate = default;
            string invoiceId = default;
            string previousInvoiceId = default;
            string pricingCurrencyCode = default;
            string productIdentifier = default;
            string resourceLocationNormalized = default;
            DateTimeOffset? servicePeriodStartDate = default;
            DateTimeOffset? servicePeriodEndDate = default;
            string customerTenantId = default;
            string customerName = default;
            string partnerTenantId = default;
            string partnerName = default;
            string resellerMpnId = default;
            string resellerName = default;
            string publisherId = default;
            decimal? marketPrice = default;
            decimal? exchangeRatePricingToBilling = default;
            decimal? paygCostInBillingCurrency = default;
            decimal? paygCostInUSD = default;
            decimal? partnerEarnedCreditRate = default;
            string partnerEarnedCreditApplied = default;
            decimal? payGPrice = default;
            string benefitId = default;
            string benefitName = default;
            string provider = default;
            string costAllocationRuleName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("kind"u8))
                {
                    kind = new UsageDetailsKind(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("etag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    etag = new ETag(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("billingAccountId"u8))
                        {
                            billingAccountId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("effectivePrice"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            effectivePrice = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("pricingModel"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            pricingModel = new ConsumptionPricingModelType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("billingAccountName"u8))
                        {
                            billingAccountName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("billingPeriodStartDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            billingPeriodStartDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("billingPeriodEndDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            billingPeriodEndDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("billingProfileId"u8))
                        {
                            billingProfileId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("billingProfileName"u8))
                        {
                            billingProfileName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("subscriptionGuid"u8))
                        {
                            subscriptionGuid = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("subscriptionName"u8))
                        {
                            subscriptionName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("date"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            date = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("product"u8))
                        {
                            product = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("meterId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            meterId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("meterName"u8))
                        {
                            meterName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("meterRegion"u8))
                        {
                            meterRegion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("meterCategory"u8))
                        {
                            meterCategory = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("meterSubCategory"u8))
                        {
                            meterSubCategory = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("serviceFamily"u8))
                        {
                            serviceFamily = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("quantity"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            quantity = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("unitOfMeasure"u8))
                        {
                            unitOfMeasure = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("instanceName"u8))
                        {
                            instanceName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("costInUSD"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            costInUSD = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("unitPrice"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            unitPrice = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("billingCurrencyCode"u8))
                        {
                            billingCurrencyCode = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("resourceLocation"u8))
                        {
                            resourceLocation = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("consumedService"u8))
                        {
                            consumedService = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("serviceInfo1"u8))
                        {
                            serviceInfo1 = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("serviceInfo2"u8))
                        {
                            serviceInfo2 = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("additionalInfo"u8))
                        {
                            additionalInfo = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("invoiceSectionId"u8))
                        {
                            invoiceSectionId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("invoiceSectionName"u8))
                        {
                            invoiceSectionName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("costCenter"u8))
                        {
                            costCenter = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("resourceGroup"u8))
                        {
                            resourceGroup = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("reservationId"u8))
                        {
                            reservationId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("reservationName"u8))
                        {
                            reservationName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("productOrderId"u8))
                        {
                            productOrderId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("productOrderName"u8))
                        {
                            productOrderName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("isAzureCreditEligible"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isAzureCreditEligible = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("term"u8))
                        {
                            term = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("publisherName"u8))
                        {
                            publisherName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("publisherType"u8))
                        {
                            publisherType = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("chargeType"u8))
                        {
                            chargeType = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("frequency"u8))
                        {
                            frequency = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("costInBillingCurrency"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            costInBillingCurrency = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("costInPricingCurrency"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            costInPricingCurrency = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("exchangeRate"u8))
                        {
                            exchangeRate = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("exchangeRateDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            exchangeRateDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("invoiceId"u8))
                        {
                            invoiceId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("previousInvoiceId"u8))
                        {
                            previousInvoiceId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("pricingCurrencyCode"u8))
                        {
                            pricingCurrencyCode = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("productIdentifier"u8))
                        {
                            productIdentifier = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("resourceLocationNormalized"u8))
                        {
                            resourceLocationNormalized = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("servicePeriodStartDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            servicePeriodStartDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("servicePeriodEndDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            servicePeriodEndDate = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("customerTenantId"u8))
                        {
                            customerTenantId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("customerName"u8))
                        {
                            customerName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("partnerTenantId"u8))
                        {
                            partnerTenantId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("partnerName"u8))
                        {
                            partnerName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("resellerMpnId"u8))
                        {
                            resellerMpnId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("resellerName"u8))
                        {
                            resellerName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("publisherId"u8))
                        {
                            publisherId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("marketPrice"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            marketPrice = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("exchangeRatePricingToBilling"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            exchangeRatePricingToBilling = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("paygCostInBillingCurrency"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            paygCostInBillingCurrency = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("paygCostInUSD"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            paygCostInUSD = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("partnerEarnedCreditRate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            partnerEarnedCreditRate = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("partnerEarnedCreditApplied"u8))
                        {
                            partnerEarnedCreditApplied = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("payGPrice"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            payGPrice = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("benefitId"u8))
                        {
                            benefitId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("benefitName"u8))
                        {
                            benefitName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("provider"u8))
                        {
                            provider = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("costAllocationRuleName"u8))
                        {
                            costAllocationRuleName = property0.Value.GetString();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConsumptionModernUsageDetail(
                id,
                name,
                type,
                systemData,
                kind,
                etag,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData,
                billingAccountId,
                effectivePrice,
                pricingModel,
                billingAccountName,
                billingPeriodStartDate,
                billingPeriodEndDate,
                billingProfileId,
                billingProfileName,
                subscriptionGuid,
                subscriptionName,
                date,
                product,
                meterId,
                meterName,
                meterRegion,
                meterCategory,
                meterSubCategory,
                serviceFamily,
                quantity,
                unitOfMeasure,
                instanceName,
                costInUSD,
                unitPrice,
                billingCurrencyCode,
                resourceLocation,
                consumedService,
                serviceInfo1,
                serviceInfo2,
                additionalInfo,
                invoiceSectionId,
                invoiceSectionName,
                costCenter,
                resourceGroup,
                reservationId,
                reservationName,
                productOrderId,
                productOrderName,
                isAzureCreditEligible,
                term,
                publisherName,
                publisherType,
                chargeType,
                frequency,
                costInBillingCurrency,
                costInPricingCurrency,
                exchangeRate,
                exchangeRateDate,
                invoiceId,
                previousInvoiceId,
                pricingCurrencyCode,
                productIdentifier,
                resourceLocationNormalized,
                servicePeriodStartDate,
                servicePeriodEndDate,
                customerTenantId,
                customerName,
                partnerTenantId,
                partnerName,
                resellerMpnId,
                resellerName,
                publisherId,
                marketPrice,
                exchangeRatePricingToBilling,
                paygCostInBillingCurrency,
                paygCostInUSD,
                partnerEarnedCreditRate,
                partnerEarnedCreditApplied,
                payGPrice,
                benefitId,
                benefitName,
                provider,
                costAllocationRuleName);
        }

        BinaryData IPersistableModel<ConsumptionModernUsageDetail>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionModernUsageDetail>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConsumptionModernUsageDetail)} does not support writing '{options.Format}' format.");
            }
        }

        ConsumptionModernUsageDetail IPersistableModel<ConsumptionModernUsageDetail>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionModernUsageDetail>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConsumptionModernUsageDetail(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConsumptionModernUsageDetail)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConsumptionModernUsageDetail>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
