// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> The ConsumptionMetricType. </summary>
    public readonly partial struct ConsumptionMetricType : IEquatable<ConsumptionMetricType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConsumptionMetricType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConsumptionMetricType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActualCostMetricTypeValue = "actualcost";
        private const string AmortizedCostMetricTypeValue = "amortizedcost";
        private const string UsageMetricTypeValue = "usage";

        /// <summary> Actual cost data. </summary>
        public static ConsumptionMetricType ActualCostMetricType { get; } = new ConsumptionMetricType(ActualCostMetricTypeValue);
        /// <summary> Amortized cost data. </summary>
        public static ConsumptionMetricType AmortizedCostMetricType { get; } = new ConsumptionMetricType(AmortizedCostMetricTypeValue);
        /// <summary> Usage data. </summary>
        public static ConsumptionMetricType UsageMetricType { get; } = new ConsumptionMetricType(UsageMetricTypeValue);
        /// <summary> Determines if two <see cref="ConsumptionMetricType"/> values are the same. </summary>
        public static bool operator ==(ConsumptionMetricType left, ConsumptionMetricType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConsumptionMetricType"/> values are not the same. </summary>
        public static bool operator !=(ConsumptionMetricType left, ConsumptionMetricType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConsumptionMetricType"/>. </summary>
        public static implicit operator ConsumptionMetricType(string value) => new ConsumptionMetricType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConsumptionMetricType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConsumptionMetricType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
