// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Consumption.Models
{
    public partial class ConsumptionMarketplace : IUtf8JsonSerializable, IJsonModel<ConsumptionMarketplace>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConsumptionMarketplace>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConsumptionMarketplace>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionMarketplace>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConsumptionMarketplace)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("etag"u8);
                writer.WriteStringValue(ETag.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(BillingPeriodId))
            {
                writer.WritePropertyName("billingPeriodId"u8);
                writer.WriteStringValue(BillingPeriodId);
            }
            if (options.Format != "W" && Optional.IsDefined(UsageStartOn))
            {
                writer.WritePropertyName("usageStart"u8);
                writer.WriteStringValue(UsageStartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(UsageEndOn))
            {
                writer.WritePropertyName("usageEnd"u8);
                writer.WriteStringValue(UsageEndOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceRate))
            {
                writer.WritePropertyName("resourceRate"u8);
                writer.WriteNumberValue(ResourceRate.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(OfferName))
            {
                writer.WritePropertyName("offerName"u8);
                writer.WriteStringValue(OfferName);
            }
            if (options.Format != "W" && Optional.IsDefined(ResourceGroup))
            {
                writer.WritePropertyName("resourceGroup"u8);
                writer.WriteStringValue(ResourceGroup);
            }
            if (options.Format != "W" && Optional.IsDefined(AdditionalInfo))
            {
                writer.WritePropertyName("additionalInfo"u8);
                writer.WriteStringValue(AdditionalInfo);
            }
            if (options.Format != "W" && Optional.IsDefined(OrderNumber))
            {
                writer.WritePropertyName("orderNumber"u8);
                writer.WriteStringValue(OrderNumber);
            }
            if (options.Format != "W" && Optional.IsDefined(InstanceName))
            {
                writer.WritePropertyName("instanceName"u8);
                writer.WriteStringValue(InstanceName);
            }
            if (options.Format != "W" && Optional.IsDefined(InstanceId))
            {
                writer.WritePropertyName("instanceId"u8);
                writer.WriteStringValue(InstanceId);
            }
            if (options.Format != "W" && Optional.IsDefined(Currency))
            {
                writer.WritePropertyName("currency"u8);
                writer.WriteStringValue(Currency);
            }
            if (options.Format != "W" && Optional.IsDefined(ConsumedQuantity))
            {
                writer.WritePropertyName("consumedQuantity"u8);
                writer.WriteNumberValue(ConsumedQuantity.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(UnitOfMeasure))
            {
                writer.WritePropertyName("unitOfMeasure"u8);
                writer.WriteStringValue(UnitOfMeasure);
            }
            if (options.Format != "W" && Optional.IsDefined(PretaxCost))
            {
                writer.WritePropertyName("pretaxCost"u8);
                writer.WriteNumberValue(PretaxCost.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(IsEstimated))
            {
                writer.WritePropertyName("isEstimated"u8);
                writer.WriteBooleanValue(IsEstimated.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MeterId))
            {
                writer.WritePropertyName("meterId"u8);
                writer.WriteStringValue(MeterId.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SubscriptionGuid))
            {
                writer.WritePropertyName("subscriptionGuid"u8);
                writer.WriteStringValue(SubscriptionGuid.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(SubscriptionName))
            {
                writer.WritePropertyName("subscriptionName"u8);
                writer.WriteStringValue(SubscriptionName);
            }
            if (options.Format != "W" && Optional.IsDefined(AccountName))
            {
                writer.WritePropertyName("accountName"u8);
                writer.WriteStringValue(AccountName);
            }
            if (options.Format != "W" && Optional.IsDefined(DepartmentName))
            {
                writer.WritePropertyName("departmentName"u8);
                writer.WriteStringValue(DepartmentName);
            }
            if (options.Format != "W" && Optional.IsDefined(ConsumedService))
            {
                writer.WritePropertyName("consumedService"u8);
                writer.WriteStringValue(ConsumedService);
            }
            if (options.Format != "W" && Optional.IsDefined(CostCenter))
            {
                writer.WritePropertyName("costCenter"u8);
                writer.WriteStringValue(CostCenter);
            }
            if (options.Format != "W" && Optional.IsDefined(AdditionalProperties))
            {
                writer.WritePropertyName("additionalProperties"u8);
                writer.WriteStringValue(AdditionalProperties);
            }
            if (options.Format != "W" && Optional.IsDefined(PublisherName))
            {
                writer.WritePropertyName("publisherName"u8);
                writer.WriteStringValue(PublisherName);
            }
            if (options.Format != "W" && Optional.IsDefined(PlanName))
            {
                writer.WritePropertyName("planName"u8);
                writer.WriteStringValue(PlanName);
            }
            if (options.Format != "W" && Optional.IsDefined(IsRecurringCharge))
            {
                writer.WritePropertyName("isRecurringCharge"u8);
                writer.WriteBooleanValue(IsRecurringCharge.Value);
            }
            writer.WriteEndObject();
        }

        ConsumptionMarketplace IJsonModel<ConsumptionMarketplace>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionMarketplace>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConsumptionMarketplace)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConsumptionMarketplace(document.RootElement, options);
        }

        internal static ConsumptionMarketplace DeserializeConsumptionMarketplace(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ETag? etag = default;
            IReadOnlyDictionary<string, string> tags = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string billingPeriodId = default;
            DateTimeOffset? usageStart = default;
            DateTimeOffset? usageEnd = default;
            decimal? resourceRate = default;
            string offerName = default;
            string resourceGroup = default;
            string additionalInfo = default;
            string orderNumber = default;
            string instanceName = default;
            string instanceId = default;
            string currency = default;
            decimal? consumedQuantity = default;
            string unitOfMeasure = default;
            decimal? pretaxCost = default;
            bool? isEstimated = default;
            Guid? meterId = default;
            Guid? subscriptionGuid = default;
            string subscriptionName = default;
            string accountName = default;
            string departmentName = default;
            string consumedService = default;
            string costCenter = default;
            string additionalProperties = default;
            string publisherName = default;
            string planName = default;
            bool? isRecurringCharge = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("etag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    etag = new ETag(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("billingPeriodId"u8))
                        {
                            billingPeriodId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("usageStart"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            usageStart = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("usageEnd"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            usageEnd = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("resourceRate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            resourceRate = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("offerName"u8))
                        {
                            offerName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("resourceGroup"u8))
                        {
                            resourceGroup = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("additionalInfo"u8))
                        {
                            additionalInfo = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("orderNumber"u8))
                        {
                            orderNumber = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("instanceName"u8))
                        {
                            instanceName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("instanceId"u8))
                        {
                            instanceId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("currency"u8))
                        {
                            currency = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("consumedQuantity"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            consumedQuantity = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("unitOfMeasure"u8))
                        {
                            unitOfMeasure = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("pretaxCost"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            pretaxCost = property0.Value.GetDecimal();
                            continue;
                        }
                        if (property0.NameEquals("isEstimated"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isEstimated = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("meterId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            meterId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("subscriptionGuid"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null || property0.Value.ValueKind == JsonValueKind.String && property0.Value.GetString().Length == 0)
                            {
                                continue;
                            }
                            subscriptionGuid = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("subscriptionName"u8))
                        {
                            subscriptionName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("accountName"u8))
                        {
                            accountName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("departmentName"u8))
                        {
                            departmentName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("consumedService"u8))
                        {
                            consumedService = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("costCenter"u8))
                        {
                            costCenter = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("additionalProperties"u8))
                        {
                            additionalProperties = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("publisherName"u8))
                        {
                            publisherName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("planName"u8))
                        {
                            planName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("isRecurringCharge"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isRecurringCharge = property0.Value.GetBoolean();
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConsumptionMarketplace(
                id,
                name,
                type,
                systemData,
                billingPeriodId,
                usageStart,
                usageEnd,
                resourceRate,
                offerName,
                resourceGroup,
                additionalInfo,
                orderNumber,
                instanceName,
                instanceId,
                currency,
                consumedQuantity,
                unitOfMeasure,
                pretaxCost,
                isEstimated,
                meterId,
                subscriptionGuid,
                subscriptionName,
                accountName,
                departmentName,
                consumedService,
                costCenter,
                additionalProperties,
                publisherName,
                planName,
                isRecurringCharge,
                etag,
                tags ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ConsumptionMarketplace>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionMarketplace>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConsumptionMarketplace)} does not support writing '{options.Format}' format.");
            }
        }

        ConsumptionMarketplace IPersistableModel<ConsumptionMarketplace>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionMarketplace>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConsumptionMarketplace(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConsumptionMarketplace)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConsumptionMarketplace>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
