// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> The source of the lot. </summary>
    public readonly partial struct ConsumptionLotSource : IEquatable<ConsumptionLotSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConsumptionLotSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConsumptionLotSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PurchasedCreditValue = "PurchasedCredit";
        private const string PromotionalCreditValue = "PromotionalCredit";
        private const string ConsumptionCommitmentValue = "ConsumptionCommitment";

        /// <summary> PurchasedCredit. </summary>
        public static ConsumptionLotSource PurchasedCredit { get; } = new ConsumptionLotSource(PurchasedCreditValue);
        /// <summary> PromotionalCredit. </summary>
        public static ConsumptionLotSource PromotionalCredit { get; } = new ConsumptionLotSource(PromotionalCreditValue);
        /// <summary> ConsumptionCommitment. </summary>
        public static ConsumptionLotSource ConsumptionCommitment { get; } = new ConsumptionLotSource(ConsumptionCommitmentValue);
        /// <summary> Determines if two <see cref="ConsumptionLotSource"/> values are the same. </summary>
        public static bool operator ==(ConsumptionLotSource left, ConsumptionLotSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConsumptionLotSource"/> values are not the same. </summary>
        public static bool operator !=(ConsumptionLotSource left, ConsumptionLotSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConsumptionLotSource"/>. </summary>
        public static implicit operator ConsumptionLotSource(string value) => new ConsumptionLotSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConsumptionLotSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConsumptionLotSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
