// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> Identifies the type of the event. </summary>
    public readonly partial struct ConsumptionEventType : IEquatable<ConsumptionEventType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConsumptionEventType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConsumptionEventType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SettledChargesValue = "SettledCharges";
        private const string PendingChargesValue = "PendingCharges";
        private const string PendingAdjustmentsValue = "PendingAdjustments";
        private const string PendingNewCreditValue = "PendingNewCredit";
        private const string PendingExpiredCreditValue = "PendingExpiredCredit";
        private const string UnKnownValue = "UnKnown";
        private const string NewCreditValue = "NewCredit";
        private const string CreditExpiredValue = "CreditExpired";

        /// <summary> SettledCharges. </summary>
        public static ConsumptionEventType SettledCharges { get; } = new ConsumptionEventType(SettledChargesValue);
        /// <summary> PendingCharges. </summary>
        public static ConsumptionEventType PendingCharges { get; } = new ConsumptionEventType(PendingChargesValue);
        /// <summary> PendingAdjustments. </summary>
        public static ConsumptionEventType PendingAdjustments { get; } = new ConsumptionEventType(PendingAdjustmentsValue);
        /// <summary> PendingNewCredit. </summary>
        public static ConsumptionEventType PendingNewCredit { get; } = new ConsumptionEventType(PendingNewCreditValue);
        /// <summary> PendingExpiredCredit. </summary>
        public static ConsumptionEventType PendingExpiredCredit { get; } = new ConsumptionEventType(PendingExpiredCreditValue);
        /// <summary> UnKnown. </summary>
        public static ConsumptionEventType UnKnown { get; } = new ConsumptionEventType(UnKnownValue);
        /// <summary> NewCredit. </summary>
        public static ConsumptionEventType NewCredit { get; } = new ConsumptionEventType(NewCreditValue);
        /// <summary> CreditExpired. </summary>
        public static ConsumptionEventType CreditExpired { get; } = new ConsumptionEventType(CreditExpiredValue);
        /// <summary> Determines if two <see cref="ConsumptionEventType"/> values are the same. </summary>
        public static bool operator ==(ConsumptionEventType left, ConsumptionEventType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConsumptionEventType"/> values are not the same. </summary>
        public static bool operator !=(ConsumptionEventType left, ConsumptionEventType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConsumptionEventType"/>. </summary>
        public static implicit operator ConsumptionEventType(string value) => new ConsumptionEventType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConsumptionEventType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConsumptionEventType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
