// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> An event summary resource. </summary>
    public partial class ConsumptionEventSummary : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConsumptionEventSummary"/>. </summary>
        public ConsumptionEventSummary()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConsumptionEventSummary"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="transactOn"> The date of the event. </param>
        /// <param name="description"> The description of the event. </param>
        /// <param name="newCredit"> The amount of new credit or commitment for NewCredit or SettleCharges event. </param>
        /// <param name="adjustments"> The amount of balance adjustment. The property is not available for ConsumptionCommitment lots. </param>
        /// <param name="creditExpired"> The amount of expired credit or commitment for NewCredit or SettleCharges event. </param>
        /// <param name="charges"> The amount of charges for events of type SettleCharges and PendingEligibleCharges. </param>
        /// <param name="closedBalance"> The balance after the event. </param>
        /// <param name="eventType"> Identifies the type of the event. </param>
        /// <param name="invoiceNumber"> The number which uniquely identifies the invoice on which the event was billed. This will be empty for unbilled events. </param>
        /// <param name="billingProfileId"> The ID that uniquely identifies the billing profile for which the event happened. The property is only available for billing account of type MicrosoftCustomerAgreement. </param>
        /// <param name="billingProfileDisplayName"> The display name of the billing profile for which the event happened. The property is only available for billing account of type MicrosoftCustomerAgreement. </param>
        /// <param name="lotId"> The ID that uniquely identifies the lot for which the event happened. </param>
        /// <param name="lotSource"> Identifies the source of the lot for which the event happened. </param>
        /// <param name="canceledCredit"> Amount of canceled credit. </param>
        /// <param name="creditCurrency"> The credit currency of the event. </param>
        /// <param name="billingCurrency"> The billing currency of the event. </param>
        /// <param name="reseller"> The reseller of the event. </param>
        /// <param name="creditExpiredInBillingCurrency"> The amount of expired credit or commitment for NewCredit or SettleCharges event in billing currency. </param>
        /// <param name="newCreditInBillingCurrency"> The amount of new credit or commitment for NewCredit or SettleCharges event in billing currency. </param>
        /// <param name="adjustmentsInBillingCurrency"> The amount of balance adjustment in billing currency. </param>
        /// <param name="chargesInBillingCurrency"> The amount of charges for events of type SettleCharges and PendingEligibleCharges in billing currency. </param>
        /// <param name="closedBalanceInBillingCurrency"> The balance in billing currency after the event. </param>
        /// <param name="etag"> eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConsumptionEventSummary(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? transactOn, string description, ConsumptionAmount newCredit, ConsumptionAmount adjustments, ConsumptionAmount creditExpired, ConsumptionAmount charges, ConsumptionAmount closedBalance, ConsumptionEventType? eventType, string invoiceNumber, ResourceIdentifier billingProfileId, string billingProfileDisplayName, ResourceIdentifier lotId, string lotSource, ConsumptionAmount canceledCredit, string creditCurrency, string billingCurrency, ConsumptionReseller reseller, ConsumptionAmountWithExchangeRate creditExpiredInBillingCurrency, ConsumptionAmountWithExchangeRate newCreditInBillingCurrency, ConsumptionAmountWithExchangeRate adjustmentsInBillingCurrency, ConsumptionAmountWithExchangeRate chargesInBillingCurrency, ConsumptionAmountWithExchangeRate closedBalanceInBillingCurrency, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            TransactOn = transactOn;
            Description = description;
            NewCredit = newCredit;
            Adjustments = adjustments;
            CreditExpired = creditExpired;
            Charges = charges;
            ClosedBalance = closedBalance;
            EventType = eventType;
            InvoiceNumber = invoiceNumber;
            BillingProfileId = billingProfileId;
            BillingProfileDisplayName = billingProfileDisplayName;
            LotId = lotId;
            LotSource = lotSource;
            CanceledCredit = canceledCredit;
            CreditCurrency = creditCurrency;
            BillingCurrency = billingCurrency;
            Reseller = reseller;
            CreditExpiredInBillingCurrency = creditExpiredInBillingCurrency;
            NewCreditInBillingCurrency = newCreditInBillingCurrency;
            AdjustmentsInBillingCurrency = adjustmentsInBillingCurrency;
            ChargesInBillingCurrency = chargesInBillingCurrency;
            ClosedBalanceInBillingCurrency = closedBalanceInBillingCurrency;
            ETag = etag;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The date of the event. </summary>
        public DateTimeOffset? TransactOn { get; }
        /// <summary> The description of the event. </summary>
        public string Description { get; }
        /// <summary> The amount of new credit or commitment for NewCredit or SettleCharges event. </summary>
        public ConsumptionAmount NewCredit { get; }
        /// <summary> The amount of balance adjustment. The property is not available for ConsumptionCommitment lots. </summary>
        public ConsumptionAmount Adjustments { get; }
        /// <summary> The amount of expired credit or commitment for NewCredit or SettleCharges event. </summary>
        public ConsumptionAmount CreditExpired { get; }
        /// <summary> The amount of charges for events of type SettleCharges and PendingEligibleCharges. </summary>
        public ConsumptionAmount Charges { get; }
        /// <summary> The balance after the event. </summary>
        public ConsumptionAmount ClosedBalance { get; }
        /// <summary> Identifies the type of the event. </summary>
        public ConsumptionEventType? EventType { get; set; }
        /// <summary> The number which uniquely identifies the invoice on which the event was billed. This will be empty for unbilled events. </summary>
        public string InvoiceNumber { get; }
        /// <summary> The ID that uniquely identifies the billing profile for which the event happened. The property is only available for billing account of type MicrosoftCustomerAgreement. </summary>
        public ResourceIdentifier BillingProfileId { get; }
        /// <summary> The display name of the billing profile for which the event happened. The property is only available for billing account of type MicrosoftCustomerAgreement. </summary>
        public string BillingProfileDisplayName { get; }
        /// <summary> The ID that uniquely identifies the lot for which the event happened. </summary>
        public ResourceIdentifier LotId { get; }
        /// <summary> Identifies the source of the lot for which the event happened. </summary>
        public string LotSource { get; }
        /// <summary> Amount of canceled credit. </summary>
        public ConsumptionAmount CanceledCredit { get; }
        /// <summary> The credit currency of the event. </summary>
        public string CreditCurrency { get; }
        /// <summary> The billing currency of the event. </summary>
        public string BillingCurrency { get; }
        /// <summary> The reseller of the event. </summary>
        public ConsumptionReseller Reseller { get; }
        /// <summary> The amount of expired credit or commitment for NewCredit or SettleCharges event in billing currency. </summary>
        public ConsumptionAmountWithExchangeRate CreditExpiredInBillingCurrency { get; }
        /// <summary> The amount of new credit or commitment for NewCredit or SettleCharges event in billing currency. </summary>
        public ConsumptionAmountWithExchangeRate NewCreditInBillingCurrency { get; }
        /// <summary> The amount of balance adjustment in billing currency. </summary>
        public ConsumptionAmountWithExchangeRate AdjustmentsInBillingCurrency { get; }
        /// <summary> The amount of charges for events of type SettleCharges and PendingEligibleCharges in billing currency. </summary>
        public ConsumptionAmountWithExchangeRate ChargesInBillingCurrency { get; }
        /// <summary> The balance in billing currency after the event. </summary>
        public ConsumptionAmountWithExchangeRate ClosedBalanceInBillingCurrency { get; }
        /// <summary> eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not. </summary>
        public ETag? ETag { get; set; }
    }
}
