// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Consumption.Models
{
    public partial class ConsumptionCalculatedSavingsProperties : IUtf8JsonSerializable, IJsonModel<ConsumptionCalculatedSavingsProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConsumptionCalculatedSavingsProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConsumptionCalculatedSavingsProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionCalculatedSavingsProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConsumptionCalculatedSavingsProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(OnDemandCost))
            {
                writer.WritePropertyName("onDemandCost"u8);
                writer.WriteNumberValue(OnDemandCost.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(OverageCost))
            {
                writer.WritePropertyName("overageCost"u8);
                writer.WriteNumberValue(OverageCost.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Quantity))
            {
                writer.WritePropertyName("quantity"u8);
                writer.WriteNumberValue(Quantity.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ReservationCost))
            {
                writer.WritePropertyName("reservationCost"u8);
                writer.WriteNumberValue(ReservationCost.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalReservationCost))
            {
                writer.WritePropertyName("totalReservationCost"u8);
                writer.WriteNumberValue(TotalReservationCost.Value);
            }
            if (Optional.IsDefined(ReservedUnitCount))
            {
                writer.WritePropertyName("reservedUnitCount"u8);
                writer.WriteNumberValue(ReservedUnitCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Savings))
            {
                writer.WritePropertyName("savings"u8);
                writer.WriteNumberValue(Savings.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ConsumptionCalculatedSavingsProperties IJsonModel<ConsumptionCalculatedSavingsProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionCalculatedSavingsProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConsumptionCalculatedSavingsProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConsumptionCalculatedSavingsProperties(document.RootElement, options);
        }

        internal static ConsumptionCalculatedSavingsProperties DeserializeConsumptionCalculatedSavingsProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            float? onDemandCost = default;
            float? overageCost = default;
            float? quantity = default;
            float? reservationCost = default;
            float? totalReservationCost = default;
            float? reservedUnitCount = default;
            float? savings = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("onDemandCost"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    onDemandCost = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("overageCost"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    overageCost = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("quantity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    quantity = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("reservationCost"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    reservationCost = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("totalReservationCost"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalReservationCost = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("reservedUnitCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    reservedUnitCount = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("savings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    savings = property.Value.GetSingle();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConsumptionCalculatedSavingsProperties(
                onDemandCost,
                overageCost,
                quantity,
                reservationCost,
                totalReservationCost,
                reservedUnitCount,
                savings,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ConsumptionCalculatedSavingsProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionCalculatedSavingsProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConsumptionCalculatedSavingsProperties)} does not support writing '{options.Format}' format.");
            }
        }

        ConsumptionCalculatedSavingsProperties IPersistableModel<ConsumptionCalculatedSavingsProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionCalculatedSavingsProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConsumptionCalculatedSavingsProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConsumptionCalculatedSavingsProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConsumptionCalculatedSavingsProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
