// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> The amount with exchange rate. </summary>
    public partial class ConsumptionAmountWithExchangeRate : ConsumptionAmount
    {
        /// <summary> Initializes a new instance of <see cref="ConsumptionAmountWithExchangeRate"/>. </summary>
        internal ConsumptionAmountWithExchangeRate()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConsumptionAmountWithExchangeRate"/>. </summary>
        /// <param name="currency"> Amount currency. </param>
        /// <param name="value"> Amount. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="exchangeRate"> The exchange rate. </param>
        /// <param name="exchangeRateMonth"> The exchange rate month. </param>
        internal ConsumptionAmountWithExchangeRate(string currency, decimal? value, IDictionary<string, BinaryData> serializedAdditionalRawData, decimal? exchangeRate, int? exchangeRateMonth) : base(currency, value, serializedAdditionalRawData)
        {
            ExchangeRate = exchangeRate;
            ExchangeRateMonth = exchangeRateMonth;
        }

        /// <summary> The exchange rate. </summary>
        public decimal? ExchangeRate { get; }
        /// <summary> The exchange rate month. </summary>
        public int? ExchangeRateMonth { get; }
    }
}
