// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Consumption.Models
{
    public partial class ConsumptionAmountWithExchangeRate : IUtf8JsonSerializable, IJsonModel<ConsumptionAmountWithExchangeRate>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ConsumptionAmountWithExchangeRate>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ConsumptionAmountWithExchangeRate>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionAmountWithExchangeRate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConsumptionAmountWithExchangeRate)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(ExchangeRate))
            {
                writer.WritePropertyName("exchangeRate"u8);
                writer.WriteNumberValue(ExchangeRate.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ExchangeRateMonth))
            {
                writer.WritePropertyName("exchangeRateMonth"u8);
                writer.WriteNumberValue(ExchangeRateMonth.Value);
            }
        }

        ConsumptionAmountWithExchangeRate IJsonModel<ConsumptionAmountWithExchangeRate>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionAmountWithExchangeRate>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ConsumptionAmountWithExchangeRate)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeConsumptionAmountWithExchangeRate(document.RootElement, options);
        }

        internal static ConsumptionAmountWithExchangeRate DeserializeConsumptionAmountWithExchangeRate(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            decimal? exchangeRate = default;
            int? exchangeRateMonth = default;
            string currency = default;
            decimal? value = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("exchangeRate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    exchangeRate = property.Value.GetDecimal();
                    continue;
                }
                if (property.NameEquals("exchangeRateMonth"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    exchangeRateMonth = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("currency"u8))
                {
                    currency = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("value"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    value = property.Value.GetDecimal();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ConsumptionAmountWithExchangeRate(currency, value, serializedAdditionalRawData, exchangeRate, exchangeRateMonth);
        }

        BinaryData IPersistableModel<ConsumptionAmountWithExchangeRate>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionAmountWithExchangeRate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ConsumptionAmountWithExchangeRate)} does not support writing '{options.Format}' format.");
            }
        }

        ConsumptionAmountWithExchangeRate IPersistableModel<ConsumptionAmountWithExchangeRate>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ConsumptionAmountWithExchangeRate>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeConsumptionAmountWithExchangeRate(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ConsumptionAmountWithExchangeRate)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ConsumptionAmountWithExchangeRate>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
