// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> The start and end date for a budget. </summary>
    public partial class BudgetTimePeriod
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BudgetTimePeriod"/>. </summary>
        /// <param name="startOn"> The start date for the budget. </param>
        public BudgetTimePeriod(DateTimeOffset startOn)
        {
            StartOn = startOn;
        }

        /// <summary> Initializes a new instance of <see cref="BudgetTimePeriod"/>. </summary>
        /// <param name="startOn"> The start date for the budget. </param>
        /// <param name="endOn"> The end date for the budget. If not provided, we default this to 10 years from the start date. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BudgetTimePeriod(DateTimeOffset startOn, DateTimeOffset? endOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StartOn = startOn;
            EndOn = endOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BudgetTimePeriod"/> for deserialization. </summary>
        internal BudgetTimePeriod()
        {
        }

        /// <summary> The start date for the budget. </summary>
        public DateTimeOffset StartOn { get; set; }
        /// <summary> The end date for the budget. If not provided, we default this to 10 years from the start date. </summary>
        public DateTimeOffset? EndOn { get; set; }
    }
}
