// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> The time covered by a budget. Tracking of the amount will be reset based on the time grain. BillingMonth, BillingQuarter, and BillingAnnual are only supported by WD customers. </summary>
    public readonly partial struct BudgetTimeGrainType : IEquatable<BudgetTimeGrainType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BudgetTimeGrainType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BudgetTimeGrainType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MonthlyValue = "Monthly";
        private const string QuarterlyValue = "Quarterly";
        private const string AnnuallyValue = "Annually";
        private const string BillingMonthValue = "BillingMonth";
        private const string BillingQuarterValue = "BillingQuarter";
        private const string BillingAnnualValue = "BillingAnnual";

        /// <summary> Monthly. </summary>
        public static BudgetTimeGrainType Monthly { get; } = new BudgetTimeGrainType(MonthlyValue);
        /// <summary> Quarterly. </summary>
        public static BudgetTimeGrainType Quarterly { get; } = new BudgetTimeGrainType(QuarterlyValue);
        /// <summary> Annually. </summary>
        public static BudgetTimeGrainType Annually { get; } = new BudgetTimeGrainType(AnnuallyValue);
        /// <summary> BillingMonth. </summary>
        public static BudgetTimeGrainType BillingMonth { get; } = new BudgetTimeGrainType(BillingMonthValue);
        /// <summary> BillingQuarter. </summary>
        public static BudgetTimeGrainType BillingQuarter { get; } = new BudgetTimeGrainType(BillingQuarterValue);
        /// <summary> BillingAnnual. </summary>
        public static BudgetTimeGrainType BillingAnnual { get; } = new BudgetTimeGrainType(BillingAnnualValue);
        /// <summary> Determines if two <see cref="BudgetTimeGrainType"/> values are the same. </summary>
        public static bool operator ==(BudgetTimeGrainType left, BudgetTimeGrainType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BudgetTimeGrainType"/> values are not the same. </summary>
        public static bool operator !=(BudgetTimeGrainType left, BudgetTimeGrainType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BudgetTimeGrainType"/>. </summary>
        public static implicit operator BudgetTimeGrainType(string value) => new BudgetTimeGrainType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BudgetTimeGrainType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BudgetTimeGrainType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
