// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> The operator to use for comparison. </summary>
    public readonly partial struct BudgetOperatorType : IEquatable<BudgetOperatorType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BudgetOperatorType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BudgetOperatorType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InValue = "In";

        /// <summary> In. </summary>
        public static BudgetOperatorType In { get; } = new BudgetOperatorType(InValue);
        /// <summary> Determines if two <see cref="BudgetOperatorType"/> values are the same. </summary>
        public static bool operator ==(BudgetOperatorType left, BudgetOperatorType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BudgetOperatorType"/> values are not the same. </summary>
        public static bool operator !=(BudgetOperatorType left, BudgetOperatorType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BudgetOperatorType"/>. </summary>
        public static implicit operator BudgetOperatorType(string value) => new BudgetOperatorType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BudgetOperatorType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BudgetOperatorType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
