// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> The category of the budget, whether the budget tracks cost or usage. </summary>
    public readonly partial struct BudgetCategory : IEquatable<BudgetCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BudgetCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BudgetCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CostValue = "Cost";

        /// <summary> Cost. </summary>
        public static BudgetCategory Cost { get; } = new BudgetCategory(CostValue);
        /// <summary> Determines if two <see cref="BudgetCategory"/> values are the same. </summary>
        public static bool operator ==(BudgetCategory left, BudgetCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BudgetCategory"/> values are not the same. </summary>
        public static bool operator !=(BudgetCategory left, BudgetCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BudgetCategory"/>. </summary>
        public static implicit operator BudgetCategory(string value) => new BudgetCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BudgetCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BudgetCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
