// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Consumption.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmConsumptionModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionUsageDetail"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Specifies the kind of usage details. </param>
        /// <param name="etag"> The etag for the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.ConsumptionUsageDetail"/> instance for mocking. </returns>
        public static ConsumptionUsageDetail ConsumptionUsageDetail(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string kind = null, ETag? etag = null, IReadOnlyDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new UnknownUsageDetail(
                id,
                name,
                resourceType,
                systemData,
                kind == null ? default : new UsageDetailsKind(kind),
                etag,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionMarketplace"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="billingPeriodId"> The id of the billing period resource that the usage belongs to. </param>
        /// <param name="usageStartOn"> The start of the date time range covered by the usage detail. </param>
        /// <param name="usageEndOn"> The end of the date time range covered by the usage detail. </param>
        /// <param name="resourceRate"> The marketplace resource rate. </param>
        /// <param name="offerName"> The type of offer. </param>
        /// <param name="resourceGroup"> The name of resource group. </param>
        /// <param name="additionalInfo"> Additional information. </param>
        /// <param name="orderNumber"> The order number. </param>
        /// <param name="instanceName"> The name of the resource instance that the usage is about. </param>
        /// <param name="instanceId"> The uri of the resource instance that the usage is about. </param>
        /// <param name="currency"> The ISO currency in which the meter is charged, for example, USD. </param>
        /// <param name="consumedQuantity"> The quantity of usage. </param>
        /// <param name="unitOfMeasure"> The unit of measure. </param>
        /// <param name="pretaxCost"> The amount of cost before tax. </param>
        /// <param name="isEstimated"> The estimated usage is subject to change. </param>
        /// <param name="meterId"> The meter id (GUID). </param>
        /// <param name="subscriptionGuid"> Subscription guid. </param>
        /// <param name="subscriptionName"> Subscription name. </param>
        /// <param name="accountName"> Account name. </param>
        /// <param name="departmentName"> Department name. </param>
        /// <param name="consumedService"> Consumed service name. </param>
        /// <param name="costCenter"> The cost center of this department if it is a department and a costcenter exists. </param>
        /// <param name="additionalProperties"> Additional details of this usage item. By default this is not populated, unless it's specified in $expand. </param>
        /// <param name="publisherName"> The name of publisher. </param>
        /// <param name="planName"> The name of plan. </param>
        /// <param name="isRecurringCharge"> Flag indicating whether this is a recurring charge or not. </param>
        /// <param name="etag"> The etag for the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.ConsumptionMarketplace"/> instance for mocking. </returns>
        public static ConsumptionMarketplace ConsumptionMarketplace(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string billingPeriodId = null, DateTimeOffset? usageStartOn = null, DateTimeOffset? usageEndOn = null, decimal? resourceRate = null, string offerName = null, string resourceGroup = null, string additionalInfo = null, string orderNumber = null, string instanceName = null, string instanceId = null, string currency = null, decimal? consumedQuantity = null, string unitOfMeasure = null, decimal? pretaxCost = null, bool? isEstimated = null, Guid? meterId = null, Guid? subscriptionGuid = null, string subscriptionName = null, string accountName = null, string departmentName = null, string consumedService = null, string costCenter = null, string additionalProperties = null, string publisherName = null, string planName = null, bool? isRecurringCharge = null, ETag? etag = null, IReadOnlyDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ConsumptionMarketplace(
                id,
                name,
                resourceType,
                systemData,
                billingPeriodId,
                usageStartOn,
                usageEndOn,
                resourceRate,
                offerName,
                resourceGroup,
                additionalInfo,
                orderNumber,
                instanceName,
                instanceId,
                currency,
                consumedQuantity,
                unitOfMeasure,
                pretaxCost,
                isEstimated,
                meterId,
                subscriptionGuid,
                subscriptionName,
                accountName,
                departmentName,
                consumedService,
                costCenter,
                additionalProperties,
                publisherName,
                planName,
                isRecurringCharge,
                etag,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Consumption.ConsumptionBudgetData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="category"> The category of the budget, whether the budget tracks cost or usage. </param>
        /// <param name="amount"> The total amount of cost to track with the budget. </param>
        /// <param name="timeGrain"> The time covered by a budget. Tracking of the amount will be reset based on the time grain. BillingMonth, BillingQuarter, and BillingAnnual are only supported by WD customers. </param>
        /// <param name="timePeriod"> Has start and end date of the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should  be selected within the timegrain period. There are no restrictions on the end date. </param>
        /// <param name="filter"> May be used to filter budgets by user-specified dimensions and/or tags. </param>
        /// <param name="currentSpend"> The current amount of cost which is being tracked for a budget. </param>
        /// <param name="notifications"> Dictionary of notifications associated with the budget. Budget can have up to five notifications. </param>
        /// <param name="forecastSpend"> The forecasted cost which is being tracked for a budget. </param>
        /// <param name="etag"> eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not. </param>
        /// <returns> A new <see cref="Consumption.ConsumptionBudgetData"/> instance for mocking. </returns>
        public static ConsumptionBudgetData ConsumptionBudgetData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, BudgetCategory? category = null, decimal? amount = null, BudgetTimeGrainType? timeGrain = null, BudgetTimePeriod timePeriod = null, ConsumptionBudgetFilter filter = null, BudgetCurrentSpend currentSpend = null, IDictionary<string, BudgetAssociatedNotification> notifications = null, BudgetForecastSpend forecastSpend = null, ETag? etag = null)
        {
            notifications ??= new Dictionary<string, BudgetAssociatedNotification>();

            return new ConsumptionBudgetData(
                id,
                name,
                resourceType,
                systemData,
                category,
                amount,
                timeGrain,
                timePeriod,
                filter,
                currentSpend,
                notifications,
                forecastSpend,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BudgetCurrentSpend"/>. </summary>
        /// <param name="amount"> The total amount of cost which is being tracked by the budget. </param>
        /// <param name="unit"> The unit of measure for the budget amount. </param>
        /// <returns> A new <see cref="Models.BudgetCurrentSpend"/> instance for mocking. </returns>
        public static BudgetCurrentSpend BudgetCurrentSpend(decimal? amount = null, string unit = null)
        {
            return new BudgetCurrentSpend(amount, unit, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BudgetForecastSpend"/>. </summary>
        /// <param name="amount"> The forecasted cost for the total time period which is being tracked by the budget. This value is only provided if the budget contains a forecast alert type. </param>
        /// <param name="unit"> The unit of measure for the budget amount. </param>
        /// <returns> A new <see cref="Models.BudgetForecastSpend"/> instance for mocking. </returns>
        public static BudgetForecastSpend BudgetForecastSpend(decimal? amount = null, string unit = null)
        {
            return new BudgetForecastSpend(amount, unit, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionTagsResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> A list of Tag. </param>
        /// <param name="nextLink"> The link (url) to the next page of results. </param>
        /// <param name="previousLink"> The link (url) to the previous page of results. </param>
        /// <param name="etag"> eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not. </param>
        /// <returns> A new <see cref="Models.ConsumptionTagsResult"/> instance for mocking. </returns>
        public static ConsumptionTagsResult ConsumptionTagsResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IEnumerable<ConsumptionTag> tags = null, string nextLink = null, string previousLink = null, ETag? etag = null)
        {
            tags ??= new List<ConsumptionTag>();

            return new ConsumptionTagsResult(
                id,
                name,
                resourceType,
                systemData,
                tags?.ToList(),
                nextLink,
                previousLink,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionChargeSummary"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Specifies the kind of charge summary. </param>
        /// <param name="etag"> eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not. </param>
        /// <returns> A new <see cref="Models.ConsumptionChargeSummary"/> instance for mocking. </returns>
        public static ConsumptionChargeSummary ConsumptionChargeSummary(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string kind = null, ETag? etag = null)
        {
            return new UnknownChargeSummary(
                id,
                name,
                resourceType,
                systemData,
                kind == null ? default : new ChargeSummaryKind(kind),
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionBalanceResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="currency"> The ISO currency in which the meter is charged, for example, USD. </param>
        /// <param name="beginningBalance"> The beginning balance for the billing period. </param>
        /// <param name="endingBalance"> The ending balance for the billing period (for open periods this will be updated daily). </param>
        /// <param name="newPurchases"> Total new purchase amount. </param>
        /// <param name="adjustments"> Total adjustment amount. </param>
        /// <param name="utilized"> Total Commitment usage. </param>
        /// <param name="serviceOverage"> Overage for Azure services. </param>
        /// <param name="chargesBilledSeparately"> Charges Billed separately. </param>
        /// <param name="totalOverage"> serviceOverage + chargesBilledSeparately. </param>
        /// <param name="totalUsage"> Azure service commitment + total Overage. </param>
        /// <param name="azureMarketplaceServiceCharges"> Total charges for Azure Marketplace. </param>
        /// <param name="billingFrequency"> The billing frequency. </param>
        /// <param name="isPriceHidden"> Price is hidden or not. </param>
        /// <param name="newPurchasesDetails"> List of new purchases. </param>
        /// <param name="adjustmentDetails"> List of Adjustments (Promo credit, SIE credit etc.). </param>
        /// <param name="etag"> The etag for the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.ConsumptionBalanceResult"/> instance for mocking. </returns>
        public static ConsumptionBalanceResult ConsumptionBalanceResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string currency = null, decimal? beginningBalance = null, decimal? endingBalance = null, decimal? newPurchases = null, decimal? adjustments = null, decimal? utilized = null, decimal? serviceOverage = null, decimal? chargesBilledSeparately = null, decimal? totalOverage = null, decimal? totalUsage = null, decimal? azureMarketplaceServiceCharges = null, ConsumptionBillingFrequency? billingFrequency = null, bool? isPriceHidden = null, IEnumerable<ConsumptionBalanceNewPurchasesDetail> newPurchasesDetails = null, IEnumerable<ConsumptionBalanceAdjustmentDetail> adjustmentDetails = null, ETag? etag = null, IReadOnlyDictionary<string, string> tags = null)
        {
            newPurchasesDetails ??= new List<ConsumptionBalanceNewPurchasesDetail>();
            adjustmentDetails ??= new List<ConsumptionBalanceAdjustmentDetail>();
            tags ??= new Dictionary<string, string>();

            return new ConsumptionBalanceResult(
                id,
                name,
                resourceType,
                systemData,
                currency,
                beginningBalance,
                endingBalance,
                newPurchases,
                adjustments,
                utilized,
                serviceOverage,
                chargesBilledSeparately,
                totalOverage,
                totalUsage,
                azureMarketplaceServiceCharges,
                billingFrequency,
                isPriceHidden,
                newPurchasesDetails?.ToList(),
                adjustmentDetails?.ToList(),
                etag,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionBalanceNewPurchasesDetail"/>. </summary>
        /// <param name="name"> the name of new purchase. </param>
        /// <param name="value"> the value of new purchase. </param>
        /// <returns> A new <see cref="Models.ConsumptionBalanceNewPurchasesDetail"/> instance for mocking. </returns>
        public static ConsumptionBalanceNewPurchasesDetail ConsumptionBalanceNewPurchasesDetail(string name = null, decimal? value = null)
        {
            return new ConsumptionBalanceNewPurchasesDetail(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionBalanceAdjustmentDetail"/>. </summary>
        /// <param name="name"> the name of new adjustment. </param>
        /// <param name="value"> the value of new adjustment. </param>
        /// <returns> A new <see cref="Models.ConsumptionBalanceAdjustmentDetail"/> instance for mocking. </returns>
        public static ConsumptionBalanceAdjustmentDetail ConsumptionBalanceAdjustmentDetail(string name = null, decimal? value = null)
        {
            return new ConsumptionBalanceAdjustmentDetail(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionReservationSummary"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="reservationOrderId"> The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents a single purchase transaction. A reservation order contains reservations. The reservation order specifies the VM size and region for the reservations. </param>
        /// <param name="reservationId"> The reservation ID is the identifier of a reservation within a reservation order. Each reservation is the grouping for applying the benefit scope and also specifies the number of instances to which the reservation benefit can be applied to. </param>
        /// <param name="skuName"> This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records. </param>
        /// <param name="reservedHours"> This is the total hours reserved. E.g. if reservation for 1 instance was made on 1 PM, this will be 11 hours for that day and 24 hours from subsequent days. </param>
        /// <param name="useOn"> Data corresponding to the utilization record. If the grain of data is monthly, it will be first day of month. </param>
        /// <param name="usedHours"> Total used hours by the reservation. </param>
        /// <param name="minUtilizationPercentage"> This is the minimum hourly utilization in the usage time (day or month). E.g. if usage record corresponds to 12/10/2017 and on that for hour 4 and 5, utilization was 10%, this field will return 10% for that day. </param>
        /// <param name="avgUtilizationPercentage"> This is average utilization for the entire time range. (day or month depending on the grain). </param>
        /// <param name="maxUtilizationPercentage"> This is the maximum hourly utilization in the usage time (day or month). E.g. if usage record corresponds to 12/10/2017 and on that for hour 4 and 5, utilization was 100%, this field will return 100% for that day. </param>
        /// <param name="kind"> The reservation kind. </param>
        /// <param name="purchasedQuantity"> This is the purchased quantity for the reservationId. </param>
        /// <param name="remainingQuantity"> This is the remaining quantity for the reservationId. </param>
        /// <param name="totalReservedQuantity"> This is the total count of instances that are reserved for the reservationId. </param>
        /// <param name="usedQuantity"> This is the used quantity for the reservationId. </param>
        /// <param name="utilizedPercentage"> This is the utilized percentage for the reservation Id. </param>
        /// <param name="etag"> The etag for the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.ConsumptionReservationSummary"/> instance for mocking. </returns>
        public static ConsumptionReservationSummary ConsumptionReservationSummary(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string reservationOrderId = null, string reservationId = null, string skuName = null, decimal? reservedHours = null, DateTimeOffset? useOn = null, decimal? usedHours = null, decimal? minUtilizationPercentage = null, decimal? avgUtilizationPercentage = null, decimal? maxUtilizationPercentage = null, string kind = null, decimal? purchasedQuantity = null, decimal? remainingQuantity = null, decimal? totalReservedQuantity = null, decimal? usedQuantity = null, decimal? utilizedPercentage = null, ETag? etag = null, IReadOnlyDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ConsumptionReservationSummary(
                id,
                name,
                resourceType,
                systemData,
                reservationOrderId,
                reservationId,
                skuName,
                reservedHours,
                useOn,
                usedHours,
                minUtilizationPercentage,
                avgUtilizationPercentage,
                maxUtilizationPercentage,
                kind,
                purchasedQuantity,
                remainingQuantity,
                totalReservedQuantity,
                usedQuantity,
                utilizedPercentage,
                etag,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionReservationDetail"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="reservationOrderId"> The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents a single purchase transaction. A reservation order contains reservations. The reservation order specifies the VM size and region for the reservations. </param>
        /// <param name="instanceFlexibilityRatio"> The instance Flexibility Ratio. </param>
        /// <param name="instanceFlexibilityGroup"> The instance Flexibility Group. </param>
        /// <param name="reservationId"> The reservation ID is the identifier of a reservation within a reservation order. Each reservation is the grouping for applying the benefit scope and also specifies the number of instances to which the reservation benefit can be applied to. </param>
        /// <param name="skuName"> This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records. </param>
        /// <param name="reservedHours"> This is the total hours reserved for the day. E.g. if reservation for 1 instance was made on 1 PM, this will be 11 hours for that day and 24 hours from subsequent days. </param>
        /// <param name="consumptionOccurredOn"> The date on which consumption occurred. </param>
        /// <param name="usedHours"> This is the total hours used by the instance. </param>
        /// <param name="instanceId"> This identifier is the name of the resource or the fully qualified Resource ID. </param>
        /// <param name="totalReservedQuantity"> This is the total count of instances that are reserved for the reservationId. </param>
        /// <param name="kind"> The reservation kind. </param>
        /// <param name="etag"> The etag for the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.ConsumptionReservationDetail"/> instance for mocking. </returns>
        public static ConsumptionReservationDetail ConsumptionReservationDetail(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string reservationOrderId = null, string instanceFlexibilityRatio = null, string instanceFlexibilityGroup = null, string reservationId = null, string skuName = null, decimal? reservedHours = null, DateTimeOffset? consumptionOccurredOn = null, decimal? usedHours = null, ResourceIdentifier instanceId = null, decimal? totalReservedQuantity = null, string kind = null, ETag? etag = null, IReadOnlyDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ConsumptionReservationDetail(
                id,
                name,
                resourceType,
                systemData,
                reservationOrderId,
                instanceFlexibilityRatio,
                instanceFlexibilityGroup,
                reservationId,
                skuName,
                reservedHours,
                consumptionOccurredOn,
                usedHours,
                instanceId,
                totalReservedQuantity,
                kind,
                etag,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionReservationRecommendation"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Specifies the kind of reservation recommendation. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="sku"> Resource sku. </param>
        /// <param name="etag"> The etag for the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.ConsumptionReservationRecommendation"/> instance for mocking. </returns>
        public static ConsumptionReservationRecommendation ConsumptionReservationRecommendation(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string kind = null, AzureLocation? location = null, string sku = null, ETag? etag = null, IReadOnlyDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new UnknownReservationRecommendation(
                id,
                name,
                resourceType,
                systemData,
                kind == null ? default : new ReservationRecommendationKind(kind),
                location,
                sku,
                etag,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionReservationRecommendationDetails"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource Location. </param>
        /// <param name="sku"> Resource sku. </param>
        /// <param name="currency"> An ISO 4217 currency code identifier for the costs and savings. </param>
        /// <param name="properties"> Resource specific properties. </param>
        /// <param name="resourceGroup"> Resource Group. </param>
        /// <param name="savings"> Savings information for the recommendation. </param>
        /// <param name="scope"> Scope of the reservation, ex: Single or Shared. </param>
        /// <param name="usage"> Historical usage details used to calculate the estimated savings. </param>
        /// <param name="etag"> The etag for the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.ConsumptionReservationRecommendationDetails"/> instance for mocking. </returns>
        public static ConsumptionReservationRecommendationDetails ConsumptionReservationRecommendationDetails(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, string sku = null, string currency = null, ConsumptionResourceProperties properties = null, string resourceGroup = null, ConsumptionSavingsProperties savings = null, string scope = null, ConsumptionUsageProperties usage = null, ETag? etag = null, IReadOnlyDictionary<string, string> tags = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ConsumptionReservationRecommendationDetails(
                id,
                name,
                resourceType,
                systemData,
                location,
                sku,
                currency,
                properties,
                resourceGroup,
                savings,
                scope,
                usage,
                etag,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionResourceProperties"/>. </summary>
        /// <param name="appliedScopes"> List of subscriptions for which the reservation is applied. </param>
        /// <param name="onDemandRate"> On demand rate of the resource. </param>
        /// <param name="product"> Azure product ex: Standard_E8s_v3 etc. </param>
        /// <param name="region"> Azure resource region ex:EastUS, WestUS etc. </param>
        /// <param name="reservationRate"> Reservation rate of the resource. </param>
        /// <param name="resourceType"> The azure resource type. </param>
        /// <returns> A new <see cref="Models.ConsumptionResourceProperties"/> instance for mocking. </returns>
        public static ConsumptionResourceProperties ConsumptionResourceProperties(IEnumerable<string> appliedScopes = null, float? onDemandRate = null, string product = null, string region = null, float? reservationRate = null, string resourceType = null)
        {
            appliedScopes ??= new List<string>();

            return new ConsumptionResourceProperties(
                appliedScopes?.ToList(),
                onDemandRate,
                product,
                region,
                reservationRate,
                resourceType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionSavingsProperties"/>. </summary>
        /// <param name="calculatedSavings"> List of calculated savings. </param>
        /// <param name="lookBackPeriod"> Number of days of usage to look back used for computing the recommendation. </param>
        /// <param name="recommendedQuantity"> Number of recommended units of the resource. </param>
        /// <param name="reservationOrderTerm"> Term period of the reservation, ex: P1Y or P3Y. </param>
        /// <param name="savingsType"> Type of savings, ex: instance. </param>
        /// <param name="unitOfMeasure"> Measurement unit ex: hour etc. </param>
        /// <returns> A new <see cref="Models.ConsumptionSavingsProperties"/> instance for mocking. </returns>
        public static ConsumptionSavingsProperties ConsumptionSavingsProperties(IEnumerable<ConsumptionCalculatedSavingsProperties> calculatedSavings = null, int? lookBackPeriod = null, float? recommendedQuantity = null, string reservationOrderTerm = null, string savingsType = null, string unitOfMeasure = null)
        {
            calculatedSavings ??= new List<ConsumptionCalculatedSavingsProperties>();

            return new ConsumptionSavingsProperties(
                calculatedSavings?.ToList(),
                lookBackPeriod,
                recommendedQuantity,
                reservationOrderTerm,
                savingsType,
                unitOfMeasure,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionCalculatedSavingsProperties"/>. </summary>
        /// <param name="onDemandCost"> The cost without reservation. </param>
        /// <param name="overageCost"> The difference between total reservation cost and reservation cost. </param>
        /// <param name="quantity"> The quantity for calculated savings. </param>
        /// <param name="reservationCost"> The exact cost of the estimated usage using reservation. </param>
        /// <param name="totalReservationCost"> The cost of the suggested quantity. </param>
        /// <param name="reservedUnitCount"> The number of reserved units used to calculate savings. Always 1 for virtual machines. </param>
        /// <param name="savings"> The amount saved by purchasing the recommended quantity of reservation. </param>
        /// <returns> A new <see cref="Models.ConsumptionCalculatedSavingsProperties"/> instance for mocking. </returns>
        public static ConsumptionCalculatedSavingsProperties ConsumptionCalculatedSavingsProperties(float? onDemandCost = null, float? overageCost = null, float? quantity = null, float? reservationCost = null, float? totalReservationCost = null, float? reservedUnitCount = null, float? savings = null)
        {
            return new ConsumptionCalculatedSavingsProperties(
                onDemandCost,
                overageCost,
                quantity,
                reservationCost,
                totalReservationCost,
                reservedUnitCount,
                savings,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionUsageProperties"/>. </summary>
        /// <param name="firstConsumptionDate"> The first usage date used for looking back for computing the recommendation. </param>
        /// <param name="lastConsumptionDate"> The last usage date used for looking back for computing the recommendation. </param>
        /// <param name="lookBackUnitType"> What the usage data values represent ex: virtual machine instance. </param>
        /// <param name="usageData"> The breakdown of historical resource usage.  The values are in the order of usage between the firstConsumptionDate and the lastConsumptionDate. </param>
        /// <param name="usageGrain"> The grain of the values represented in the usage data ex: hourly. </param>
        /// <returns> A new <see cref="Models.ConsumptionUsageProperties"/> instance for mocking. </returns>
        public static ConsumptionUsageProperties ConsumptionUsageProperties(string firstConsumptionDate = null, string lastConsumptionDate = null, string lookBackUnitType = null, IEnumerable<float> usageData = null, string usageGrain = null)
        {
            usageData ??= new List<float>();

            return new ConsumptionUsageProperties(
                firstConsumptionDate,
                lastConsumptionDate,
                lookBackUnitType,
                usageData?.ToList(),
                usageGrain,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionReservationTransaction"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="transactOn"> The date of the transaction. </param>
        /// <param name="reservationOrderId"> The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents a single purchase transaction. A reservation order contains reservations. The reservation order specifies the VM size and region for the reservations. </param>
        /// <param name="description"> The description of the transaction. </param>
        /// <param name="eventType"> The type of the transaction (Purchase, Cancel or Refund). </param>
        /// <param name="quantity"> The quantity of the transaction. </param>
        /// <param name="amount"> The charge of the transaction. </param>
        /// <param name="currency"> The ISO currency in which the transaction is charged, for example, USD. </param>
        /// <param name="reservationOrderName"> The name of the reservation order. </param>
        /// <param name="purchasingEnrollment"> The purchasing enrollment. </param>
        /// <param name="purchasingSubscriptionGuid"> The subscription guid that makes the transaction. </param>
        /// <param name="purchasingSubscriptionName"> The subscription name that makes the transaction. </param>
        /// <param name="armSkuName"> This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records. </param>
        /// <param name="term"> This is the term of the transaction. </param>
        /// <param name="region"> The region of the transaction. </param>
        /// <param name="accountName"> The name of the account that makes the transaction. </param>
        /// <param name="accountOwnerEmail"> The email of the account owner that makes the transaction. </param>
        /// <param name="departmentName"> The department name. </param>
        /// <param name="costCenter"> The cost center of this department if it is a department and a cost center is provided. </param>
        /// <param name="currentEnrollment"> The current enrollment. </param>
        /// <param name="billingFrequency"> The billing frequency, which can be either one-time or recurring. </param>
        /// <param name="billingMonth"> The billing month(yyyyMMdd), on which the event initiated. </param>
        /// <param name="monetaryCommitment"> The monetary commitment amount at the enrollment scope. </param>
        /// <param name="overage"> The overage amount at the enrollment scope. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.ConsumptionReservationTransaction"/> instance for mocking. </returns>
        public static ConsumptionReservationTransaction ConsumptionReservationTransaction(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? transactOn = null, string reservationOrderId = null, string description = null, string eventType = null, decimal? quantity = null, decimal? amount = null, string currency = null, string reservationOrderName = null, string purchasingEnrollment = null, Guid? purchasingSubscriptionGuid = null, string purchasingSubscriptionName = null, string armSkuName = null, string term = null, string region = null, string accountName = null, string accountOwnerEmail = null, string departmentName = null, string costCenter = null, string currentEnrollment = null, string billingFrequency = null, int? billingMonth = null, decimal? monetaryCommitment = null, decimal? overage = null, IEnumerable<string> tags = null)
        {
            tags ??= new List<string>();

            return new ConsumptionReservationTransaction(
                id,
                name,
                resourceType,
                systemData,
                transactOn,
                reservationOrderId,
                description,
                eventType,
                quantity,
                amount,
                currency,
                reservationOrderName,
                purchasingEnrollment,
                purchasingSubscriptionGuid,
                purchasingSubscriptionName,
                armSkuName,
                term,
                region,
                accountName,
                accountOwnerEmail,
                departmentName,
                costCenter,
                currentEnrollment,
                billingFrequency,
                billingMonth,
                monetaryCommitment,
                overage,
                tags?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionModernReservationTransaction"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="amount"> The charge of the transaction. </param>
        /// <param name="armSkuName"> This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records. </param>
        /// <param name="billingFrequency"> The billing frequency, which can be either one-time or recurring. </param>
        /// <param name="billingProfileId"> Billing profile Id. </param>
        /// <param name="billingProfileName"> Billing profile name. </param>
        /// <param name="currency"> The ISO currency in which the transaction is charged, for example, USD. </param>
        /// <param name="description"> The description of the transaction. </param>
        /// <param name="transactOn"> The date of the transaction. </param>
        /// <param name="eventType"> The type of the transaction (Purchase, Cancel or Refund). </param>
        /// <param name="invoice"> Invoice Number. </param>
        /// <param name="invoiceId"> Invoice Id as on the invoice where the specific transaction appears. </param>
        /// <param name="invoiceSectionId"> Invoice Section Id. </param>
        /// <param name="invoiceSectionName"> Invoice Section Name. </param>
        /// <param name="purchasingSubscriptionGuid"> The subscription guid that makes the transaction. </param>
        /// <param name="purchasingSubscriptionName"> The subscription name that makes the transaction. </param>
        /// <param name="quantity"> The quantity of the transaction. </param>
        /// <param name="region"> The region of the transaction. </param>
        /// <param name="reservationOrderId"> The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents a single purchase transaction. A reservation order contains reservations. The reservation order specifies the VM size and region for the reservations. </param>
        /// <param name="reservationOrderName"> The name of the reservation order. </param>
        /// <param name="term"> This is the term of the transaction. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.ConsumptionModernReservationTransaction"/> instance for mocking. </returns>
        public static ConsumptionModernReservationTransaction ConsumptionModernReservationTransaction(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, decimal? amount = null, string armSkuName = null, string billingFrequency = null, ResourceIdentifier billingProfileId = null, string billingProfileName = null, string currency = null, string description = null, DateTimeOffset? transactOn = null, string eventType = null, string invoice = null, ResourceIdentifier invoiceId = null, ResourceIdentifier invoiceSectionId = null, string invoiceSectionName = null, Guid? purchasingSubscriptionGuid = null, string purchasingSubscriptionName = null, decimal? quantity = null, string region = null, string reservationOrderId = null, string reservationOrderName = null, string term = null, IEnumerable<string> tags = null)
        {
            tags ??= new List<string>();

            return new ConsumptionModernReservationTransaction(
                id,
                name,
                resourceType,
                systemData,
                amount,
                armSkuName,
                billingFrequency,
                billingProfileId,
                billingProfileName,
                currency,
                description,
                transactOn,
                eventType,
                invoice,
                invoiceId,
                invoiceSectionId,
                invoiceSectionName,
                purchasingSubscriptionGuid,
                purchasingSubscriptionName,
                quantity,
                region,
                reservationOrderId,
                reservationOrderName,
                term,
                tags?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PriceSheetResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="pricesheets"> Price sheet. </param>
        /// <param name="nextLink"> The link (url) to the next page of results. </param>
        /// <param name="download"> Pricesheet download details. </param>
        /// <param name="etag"> The etag for the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.PriceSheetResult"/> instance for mocking. </returns>
        public static PriceSheetResult PriceSheetResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IEnumerable<PriceSheetProperties> pricesheets = null, string nextLink = null, ConsumptionMeterDetails download = null, ETag? etag = null, IReadOnlyDictionary<string, string> tags = null)
        {
            pricesheets ??= new List<PriceSheetProperties>();
            tags ??= new Dictionary<string, string>();

            return new PriceSheetResult(
                id,
                name,
                resourceType,
                systemData,
                pricesheets?.ToList(),
                nextLink,
                download,
                etag,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PriceSheetProperties"/>. </summary>
        /// <param name="billingPeriodId"> The id of the billing period resource that the usage belongs to. </param>
        /// <param name="meterId"> The meter id (GUID). </param>
        /// <param name="meterDetails"> The details about the meter. By default this is not populated, unless it's specified in $expand. </param>
        /// <param name="unitOfMeasure"> Unit of measure. </param>
        /// <param name="includedQuantity"> Included quality for an offer. </param>
        /// <param name="partNumber"> Part Number. </param>
        /// <param name="unitPrice"> Unit Price. </param>
        /// <param name="currencyCode"> Currency Code. </param>
        /// <param name="offerId"> Offer Id. </param>
        /// <returns> A new <see cref="Models.PriceSheetProperties"/> instance for mocking. </returns>
        public static PriceSheetProperties PriceSheetProperties(ResourceIdentifier billingPeriodId = null, Guid? meterId = null, ConsumptionMeterDetails meterDetails = null, string unitOfMeasure = null, decimal? includedQuantity = null, string partNumber = null, decimal? unitPrice = null, string currencyCode = null, string offerId = null)
        {
            return new PriceSheetProperties(
                billingPeriodId,
                meterId,
                meterDetails,
                unitOfMeasure,
                includedQuantity,
                partNumber,
                unitPrice,
                currencyCode,
                offerId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionMeterDetails"/>. </summary>
        /// <param name="meterName"> The name of the meter, within the given meter category. </param>
        /// <param name="meterCategory"> The category of the meter, for example, 'Cloud services', 'Networking', etc.. </param>
        /// <param name="meterSubCategory"> The subcategory of the meter, for example, 'A6 Cloud services', 'ExpressRoute (IXP)', etc.. </param>
        /// <param name="unit"> The unit in which the meter consumption is charged, for example, 'Hours', 'GB', etc. </param>
        /// <param name="meterLocation"> The location in which the Azure service is available. </param>
        /// <param name="totalIncludedQuantity"> The total included quantity associated with the offer. </param>
        /// <param name="pretaxStandardRate"> The pretax listing price. </param>
        /// <param name="serviceName"> The name of the service. </param>
        /// <param name="serviceTier"> The service tier. </param>
        /// <returns> A new <see cref="Models.ConsumptionMeterDetails"/> instance for mocking. </returns>
        public static ConsumptionMeterDetails ConsumptionMeterDetails(string meterName = null, string meterCategory = null, string meterSubCategory = null, string unit = null, string meterLocation = null, decimal? totalIncludedQuantity = null, decimal? pretaxStandardRate = null, string serviceName = null, string serviceTier = null)
        {
            return new ConsumptionMeterDetails(
                meterName,
                meterCategory,
                meterSubCategory,
                unit,
                meterLocation,
                totalIncludedQuantity,
                pretaxStandardRate,
                serviceName,
                serviceTier,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionAggregatedCostResult"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="billingPeriodId"> The id of the billing period resource that the aggregated cost belongs to. </param>
        /// <param name="usageStartOn"> The start of the date time range covered by aggregated cost. </param>
        /// <param name="usageEndOn"> The end of the date time range covered by the aggregated cost. </param>
        /// <param name="azureCharges"> Azure Charges. </param>
        /// <param name="marketplaceCharges"> Marketplace Charges. </param>
        /// <param name="chargesBilledSeparately"> Charges Billed Separately. </param>
        /// <param name="currency"> The ISO currency in which the meter is charged, for example, USD. </param>
        /// <param name="children"> Children of a management group. </param>
        /// <param name="includedSubscriptions"> List of subscription Guids included in the calculation of aggregated cost. </param>
        /// <param name="excludedSubscriptions"> List of subscription Guids excluded from the calculation of aggregated cost. </param>
        /// <param name="etag"> The etag for the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <returns> A new <see cref="Models.ConsumptionAggregatedCostResult"/> instance for mocking. </returns>
        public static ConsumptionAggregatedCostResult ConsumptionAggregatedCostResult(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string billingPeriodId = null, DateTimeOffset? usageStartOn = null, DateTimeOffset? usageEndOn = null, decimal? azureCharges = null, decimal? marketplaceCharges = null, decimal? chargesBilledSeparately = null, string currency = null, IEnumerable<ConsumptionAggregatedCostResult> children = null, IEnumerable<string> includedSubscriptions = null, IEnumerable<string> excludedSubscriptions = null, ETag? etag = null, IReadOnlyDictionary<string, string> tags = null)
        {
            children ??= new List<ConsumptionAggregatedCostResult>();
            includedSubscriptions ??= new List<string>();
            excludedSubscriptions ??= new List<string>();
            tags ??= new Dictionary<string, string>();

            return new ConsumptionAggregatedCostResult(
                id,
                name,
                resourceType,
                systemData,
                billingPeriodId,
                usageStartOn,
                usageEndOn,
                azureCharges,
                marketplaceCharges,
                chargesBilledSeparately,
                currency,
                children?.ToList(),
                includedSubscriptions?.ToList(),
                excludedSubscriptions?.ToList(),
                etag,
                tags,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionEventSummary"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="transactOn"> The date of the event. </param>
        /// <param name="description"> The description of the event. </param>
        /// <param name="newCredit"> The amount of new credit or commitment for NewCredit or SettleCharges event. </param>
        /// <param name="adjustments"> The amount of balance adjustment. The property is not available for ConsumptionCommitment lots. </param>
        /// <param name="creditExpired"> The amount of expired credit or commitment for NewCredit or SettleCharges event. </param>
        /// <param name="charges"> The amount of charges for events of type SettleCharges and PendingEligibleCharges. </param>
        /// <param name="closedBalance"> The balance after the event. </param>
        /// <param name="eventType"> Identifies the type of the event. </param>
        /// <param name="invoiceNumber"> The number which uniquely identifies the invoice on which the event was billed. This will be empty for unbilled events. </param>
        /// <param name="billingProfileId"> The ID that uniquely identifies the billing profile for which the event happened. The property is only available for billing account of type MicrosoftCustomerAgreement. </param>
        /// <param name="billingProfileDisplayName"> The display name of the billing profile for which the event happened. The property is only available for billing account of type MicrosoftCustomerAgreement. </param>
        /// <param name="lotId"> The ID that uniquely identifies the lot for which the event happened. </param>
        /// <param name="lotSource"> Identifies the source of the lot for which the event happened. </param>
        /// <param name="canceledCredit"> Amount of canceled credit. </param>
        /// <param name="creditCurrency"> The credit currency of the event. </param>
        /// <param name="billingCurrency"> The billing currency of the event. </param>
        /// <param name="reseller"> The reseller of the event. </param>
        /// <param name="creditExpiredInBillingCurrency"> The amount of expired credit or commitment for NewCredit or SettleCharges event in billing currency. </param>
        /// <param name="newCreditInBillingCurrency"> The amount of new credit or commitment for NewCredit or SettleCharges event in billing currency. </param>
        /// <param name="adjustmentsInBillingCurrency"> The amount of balance adjustment in billing currency. </param>
        /// <param name="chargesInBillingCurrency"> The amount of charges for events of type SettleCharges and PendingEligibleCharges in billing currency. </param>
        /// <param name="closedBalanceInBillingCurrency"> The balance in billing currency after the event. </param>
        /// <param name="etag"> eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not. </param>
        /// <returns> A new <see cref="Models.ConsumptionEventSummary"/> instance for mocking. </returns>
        public static ConsumptionEventSummary ConsumptionEventSummary(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, DateTimeOffset? transactOn = null, string description = null, ConsumptionAmount newCredit = null, ConsumptionAmount adjustments = null, ConsumptionAmount creditExpired = null, ConsumptionAmount charges = null, ConsumptionAmount closedBalance = null, ConsumptionEventType? eventType = null, string invoiceNumber = null, ResourceIdentifier billingProfileId = null, string billingProfileDisplayName = null, ResourceIdentifier lotId = null, string lotSource = null, ConsumptionAmount canceledCredit = null, string creditCurrency = null, string billingCurrency = null, ConsumptionReseller reseller = null, ConsumptionAmountWithExchangeRate creditExpiredInBillingCurrency = null, ConsumptionAmountWithExchangeRate newCreditInBillingCurrency = null, ConsumptionAmountWithExchangeRate adjustmentsInBillingCurrency = null, ConsumptionAmountWithExchangeRate chargesInBillingCurrency = null, ConsumptionAmountWithExchangeRate closedBalanceInBillingCurrency = null, ETag? etag = null)
        {
            return new ConsumptionEventSummary(
                id,
                name,
                resourceType,
                systemData,
                transactOn,
                description,
                newCredit,
                adjustments,
                creditExpired,
                charges,
                closedBalance,
                eventType,
                invoiceNumber,
                billingProfileId,
                billingProfileDisplayName,
                lotId,
                lotSource,
                canceledCredit,
                creditCurrency,
                billingCurrency,
                reseller,
                creditExpiredInBillingCurrency,
                newCreditInBillingCurrency,
                adjustmentsInBillingCurrency,
                chargesInBillingCurrency,
                closedBalanceInBillingCurrency,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionAmount"/>. </summary>
        /// <param name="currency"> Amount currency. </param>
        /// <param name="value"> Amount. </param>
        /// <returns> A new <see cref="Models.ConsumptionAmount"/> instance for mocking. </returns>
        public static ConsumptionAmount ConsumptionAmount(string currency = null, decimal? value = null)
        {
            return new ConsumptionAmount(currency, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionReseller"/>. </summary>
        /// <param name="resellerId"> The reseller property ID. </param>
        /// <param name="resellerDescription"> The reseller property description. </param>
        /// <returns> A new <see cref="Models.ConsumptionReseller"/> instance for mocking. </returns>
        public static ConsumptionReseller ConsumptionReseller(ResourceIdentifier resellerId = null, string resellerDescription = null)
        {
            return new ConsumptionReseller(resellerId, resellerDescription, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionAmountWithExchangeRate"/>. </summary>
        /// <param name="currency"> Amount currency. </param>
        /// <param name="value"> Amount. </param>
        /// <param name="exchangeRate"> The exchange rate. </param>
        /// <param name="exchangeRateMonth"> The exchange rate month. </param>
        /// <returns> A new <see cref="Models.ConsumptionAmountWithExchangeRate"/> instance for mocking. </returns>
        public static ConsumptionAmountWithExchangeRate ConsumptionAmountWithExchangeRate(string currency = null, decimal? value = null, decimal? exchangeRate = null, int? exchangeRateMonth = null)
        {
            return new ConsumptionAmountWithExchangeRate(currency, value, serializedAdditionalRawData: null, exchangeRate, exchangeRateMonth);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionLotSummary"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="originalAmount"> The original amount of a lot. </param>
        /// <param name="closedBalance"> The balance as of the last invoice. </param>
        /// <param name="source"> The source of the lot. </param>
        /// <param name="startOn"> The date when the lot became effective. </param>
        /// <param name="expireOn"> The expiration date of a lot. </param>
        /// <param name="poNumber"> The po number of the invoice on which the lot was added. This property is not available for ConsumptionCommitment lots. </param>
        /// <param name="purchasedOn"> The date when the lot was added. </param>
        /// <param name="status"> The status of the lot. </param>
        /// <param name="creditCurrency"> The currency of the lot. </param>
        /// <param name="billingCurrency"> The billing currency of the lot. </param>
        /// <param name="originalAmountInBillingCurrency"> The original amount of a lot in billing currency. </param>
        /// <param name="closedBalanceInBillingCurrency"> The balance as of the last invoice in billing currency. </param>
        /// <param name="reseller"> The reseller of the lot. </param>
        /// <param name="etag"> eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not. </param>
        /// <returns> A new <see cref="Models.ConsumptionLotSummary"/> instance for mocking. </returns>
        public static ConsumptionLotSummary ConsumptionLotSummary(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ConsumptionAmount originalAmount = null, ConsumptionAmount closedBalance = null, ConsumptionLotSource? source = null, DateTimeOffset? startOn = null, DateTimeOffset? expireOn = null, string poNumber = null, DateTimeOffset? purchasedOn = null, ConsumptionLotStatus? status = null, string creditCurrency = null, string billingCurrency = null, ConsumptionAmountWithExchangeRate originalAmountInBillingCurrency = null, ConsumptionAmountWithExchangeRate closedBalanceInBillingCurrency = null, ConsumptionReseller reseller = null, ETag? etag = null)
        {
            return new ConsumptionLotSummary(
                id,
                name,
                resourceType,
                systemData,
                originalAmount,
                closedBalance,
                source,
                startOn,
                expireOn,
                poNumber,
                purchasedOn,
                status,
                creditCurrency,
                billingCurrency,
                originalAmountInBillingCurrency,
                closedBalanceInBillingCurrency,
                reseller,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionCreditSummary"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="balanceSummary"> Summary of balances associated with this credit summary. </param>
        /// <param name="pendingCreditAdjustments"> Pending credit adjustments. </param>
        /// <param name="expiredCredit"> Expired credit. </param>
        /// <param name="pendingEligibleCharges"> Pending eligible charges. </param>
        /// <param name="creditCurrency"> The credit currency. </param>
        /// <param name="billingCurrency"> The billing currency. </param>
        /// <param name="reseller"> Credit's reseller. </param>
        /// <param name="etag"> eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not. </param>
        /// <returns> A new <see cref="Models.ConsumptionCreditSummary"/> instance for mocking. </returns>
        public static ConsumptionCreditSummary ConsumptionCreditSummary(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, CreditBalanceSummary balanceSummary = null, ConsumptionAmount pendingCreditAdjustments = null, ConsumptionAmount expiredCredit = null, ConsumptionAmount pendingEligibleCharges = null, string creditCurrency = null, string billingCurrency = null, ConsumptionReseller reseller = null, ETag? etag = null)
        {
            return new ConsumptionCreditSummary(
                id,
                name,
                resourceType,
                systemData,
                balanceSummary,
                pendingCreditAdjustments,
                expiredCredit,
                pendingEligibleCharges,
                creditCurrency,
                billingCurrency,
                reseller,
                etag,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CreditBalanceSummary"/>. </summary>
        /// <param name="estimatedBalance"> Estimated balance. </param>
        /// <param name="currentBalance"> Current balance. </param>
        /// <param name="estimatedBalanceInBillingCurrency"> Estimated balance in billing currency. </param>
        /// <returns> A new <see cref="Models.CreditBalanceSummary"/> instance for mocking. </returns>
        public static CreditBalanceSummary CreditBalanceSummary(ConsumptionAmount estimatedBalance = null, ConsumptionAmount currentBalance = null, ConsumptionAmountWithExchangeRate estimatedBalanceInBillingCurrency = null)
        {
            return new CreditBalanceSummary(estimatedBalance, currentBalance, estimatedBalanceInBillingCurrency, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionLegacyUsageDetail"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> The etag for the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="billingAccountId"> Billing Account identifier. </param>
        /// <param name="billingAccountName"> Billing Account Name. </param>
        /// <param name="billingPeriodStartOn"> The billing period start date. </param>
        /// <param name="billingPeriodEndOn"> The billing period end date. </param>
        /// <param name="billingProfileId"> Billing Profile identifier. </param>
        /// <param name="billingProfileName"> Billing Profile Name. </param>
        /// <param name="accountOwnerId"> Account Owner Id. </param>
        /// <param name="accountName"> Account Name. </param>
        /// <param name="subscriptionId"> Subscription guid. </param>
        /// <param name="subscriptionName"> Subscription name. </param>
        /// <param name="on"> Date for the usage record. </param>
        /// <param name="product"> Product name for the consumed service or purchase. Not available for Marketplace. </param>
        /// <param name="partNumber"> Part Number of the service used. Can be used to join with the price sheet. Not available for marketplace. </param>
        /// <param name="meterId"> The meter id (GUID). Not available for marketplace. For reserved instance this represents the primary meter for which the reservation was purchased. For the actual VM Size for which the reservation is purchased see productOrderName. </param>
        /// <param name="meterDetails"> The details about the meter. By default this is not populated, unless it's specified in $expand. </param>
        /// <param name="quantity"> The usage quantity. </param>
        /// <param name="effectivePrice"> Effective Price that's charged for the usage. </param>
        /// <param name="cost"> The amount of cost before tax. </param>
        /// <param name="unitPrice"> Unit Price is the price applicable to you. (your EA or other contract price). </param>
        /// <param name="billingCurrency"> Billing Currency. </param>
        /// <param name="resourceLocation"> Resource Location. </param>
        /// <param name="consumedService"> Consumed service name. Name of the azure resource provider that emits the usage or was purchased. This value is not provided for marketplace usage. </param>
        /// <param name="resourceId"> Unique identifier of the Azure Resource Manager usage detail resource. </param>
        /// <param name="resourceName"> Resource Name. </param>
        /// <param name="serviceInfo1"> Service-specific metadata. </param>
        /// <param name="serviceInfo2"> Legacy field with optional service-specific metadata. </param>
        /// <param name="additionalInfo"> Additional details of this usage item. By default this is not populated, unless it's specified in $expand. Use this field to get usage line item specific details such as the actual VM Size (ServiceType) or the ratio in which the reservation discount is applied. </param>
        /// <param name="invoiceSection"> Invoice Section Name. </param>
        /// <param name="costCenter"> The cost center of this department if it is a department and a cost center is provided. </param>
        /// <param name="resourceGroup"> Resource Group Name. </param>
        /// <param name="reservationId"> ARM resource id of the reservation. Only applies to records relevant to reservations. </param>
        /// <param name="reservationName"> User provided display name of the reservation. Last known name for a particular day is populated in the daily data. Only applies to records relevant to reservations. </param>
        /// <param name="productOrderId"> Product Order Id. For reservations this is the Reservation Order ID. </param>
        /// <param name="productOrderName"> Product Order Name. For reservations this is the SKU that was purchased. </param>
        /// <param name="offerId"> Offer Id. Ex: MS-AZR-0017P, MS-AZR-0148P. </param>
        /// <param name="isAzureCreditEligible"> Is Azure Credit Eligible. </param>
        /// <param name="term"> Term (in months). 1 month for monthly recurring purchase. 12 months for a 1 year reservation. 36 months for a 3 year reservation. </param>
        /// <param name="publisherName"> Publisher Name. </param>
        /// <param name="publisherType"> Publisher Type. </param>
        /// <param name="planName"> Plan Name. </param>
        /// <param name="chargeType"> Indicates a charge represents credits, usage, a Marketplace purchase, a reservation fee, or a refund. </param>
        /// <param name="frequency"> Indicates how frequently this charge will occur. OneTime for purchases which only happen once, Monthly for fees which recur every month, and UsageBased for charges based on how much a service is used. </param>
        /// <param name="payGPrice"> Retail price for the resource. </param>
        /// <param name="benefitId"> Unique identifier for the applicable benefit. </param>
        /// <param name="benefitName"> Name of the applicable benefit. </param>
        /// <param name="pricingModel"> Identifier that indicates how the meter is priced. </param>
        /// <returns> A new <see cref="Models.ConsumptionLegacyUsageDetail"/> instance for mocking. </returns>
        public static ConsumptionLegacyUsageDetail ConsumptionLegacyUsageDetail(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, IReadOnlyDictionary<string, string> tags = null, string billingAccountId = null, string billingAccountName = null, DateTimeOffset? billingPeriodStartOn = null, DateTimeOffset? billingPeriodEndOn = null, string billingProfileId = null, string billingProfileName = null, string accountOwnerId = null, string accountName = null, string subscriptionId = null, string subscriptionName = null, DateTimeOffset? @on = null, string product = null, string partNumber = null, Guid? meterId = null, ConsumptionMeterDetailsInfo meterDetails = null, decimal? quantity = null, decimal? effectivePrice = null, decimal? cost = null, decimal? unitPrice = null, string billingCurrency = null, string resourceLocation = null, string consumedService = null, string resourceId = null, string resourceName = null, string serviceInfo1 = null, string serviceInfo2 = null, string additionalInfo = null, string invoiceSection = null, string costCenter = null, string resourceGroup = null, string reservationId = null, string reservationName = null, string productOrderId = null, string productOrderName = null, string offerId = null, bool? isAzureCreditEligible = null, string term = null, string publisherName = null, string publisherType = null, string planName = null, string chargeType = null, string frequency = null, decimal? payGPrice = null, string benefitId = null, string benefitName = null, ConsumptionPricingModelType? pricingModel = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ConsumptionLegacyUsageDetail(
                id,
                name,
                resourceType,
                systemData,
                UsageDetailsKind.Legacy,
                etag,
                tags,
                serializedAdditionalRawData: null,
                billingAccountId,
                billingAccountName,
                billingPeriodStartOn,
                billingPeriodEndOn,
                billingProfileId,
                billingProfileName,
                accountOwnerId,
                accountName,
                subscriptionId,
                subscriptionName,
                @on,
                product,
                partNumber,
                meterId,
                meterDetails,
                quantity,
                effectivePrice,
                cost,
                unitPrice,
                billingCurrency,
                resourceLocation,
                consumedService,
                resourceId,
                resourceName,
                serviceInfo1,
                serviceInfo2,
                additionalInfo,
                invoiceSection,
                costCenter,
                resourceGroup,
                reservationId,
                reservationName,
                productOrderId,
                productOrderName,
                offerId,
                isAzureCreditEligible,
                term,
                publisherName,
                publisherType,
                planName,
                chargeType,
                frequency,
                payGPrice,
                benefitId,
                benefitName,
                pricingModel);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionMeterDetailsInfo"/>. </summary>
        /// <param name="meterName"> The name of the meter, within the given meter category. </param>
        /// <param name="meterCategory"> The category of the meter, for example, 'Cloud services', 'Networking', etc.. </param>
        /// <param name="meterSubCategory"> The subcategory of the meter, for example, 'A6 Cloud services', 'ExpressRoute (IXP)', etc.. </param>
        /// <param name="unitOfMeasure"> The unit in which the meter consumption is charged, for example, 'Hours', 'GB', etc. </param>
        /// <param name="serviceFamily"> The service family. </param>
        /// <returns> A new <see cref="Models.ConsumptionMeterDetailsInfo"/> instance for mocking. </returns>
        public static ConsumptionMeterDetailsInfo ConsumptionMeterDetailsInfo(string meterName = null, string meterCategory = null, string meterSubCategory = null, string unitOfMeasure = null, string serviceFamily = null)
        {
            return new ConsumptionMeterDetailsInfo(
                meterName,
                meterCategory,
                meterSubCategory,
                unitOfMeasure,
                serviceFamily,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionModernUsageDetail"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> The etag for the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="billingAccountId"> Billing Account identifier. </param>
        /// <param name="effectivePrice"> Effective Price that's charged for the usage. </param>
        /// <param name="pricingModel"> Identifier that indicates how the meter is priced. </param>
        /// <param name="billingAccountName"> Name of the Billing Account. </param>
        /// <param name="billingPeriodStartOn"> Billing Period Start Date as in the invoice. </param>
        /// <param name="billingPeriodEndOn"> Billing Period End Date as in the invoice. </param>
        /// <param name="billingProfileId"> Identifier for the billing profile that groups costs across invoices in the a singular billing currency across across the customers who have onboarded the Microsoft customer agreement and the customers in CSP who have made entitlement purchases like SaaS, Marketplace, RI, etc. </param>
        /// <param name="billingProfileName"> Name of the billing profile that groups costs across invoices in the a singular billing currency across across the customers who have onboarded the Microsoft customer agreement and the customers in CSP who have made entitlement purchases like SaaS, Marketplace, RI, etc. </param>
        /// <param name="subscriptionGuid"> Unique Microsoft generated identifier for the Azure Subscription. </param>
        /// <param name="subscriptionName"> Name of the Azure Subscription. </param>
        /// <param name="on"> Date for the usage record. </param>
        /// <param name="product"> Name of the product that has accrued charges by consumption or purchase as listed in the invoice. Not available for Marketplace. </param>
        /// <param name="meterId"> The meter id (GUID). Not available for marketplace. For reserved instance this represents the primary meter for which the reservation was purchased. For the actual VM Size for which the reservation is purchased see productOrderName. </param>
        /// <param name="meterName"> Identifies the name of the meter against which consumption is measured. </param>
        /// <param name="meterRegion"> Identifies the location of the datacenter for certain services that are priced based on datacenter location. </param>
        /// <param name="meterCategory"> Identifies the top-level service for the usage. </param>
        /// <param name="meterSubCategory"> Defines the type or sub-category of Azure service that can affect the rate. </param>
        /// <param name="serviceFamily"> List the service family for the product purchased or charged (Example: Storage ; Compute). </param>
        /// <param name="quantity"> Measure the quantity purchased or consumed.The amount of the meter used during the billing period. </param>
        /// <param name="unitOfMeasure"> Identifies the Unit that the service is charged in. For example, GB, hours, 10,000 s. </param>
        /// <param name="instanceName"> Instance Name. </param>
        /// <param name="costInUSD"> Estimated extendedCost or blended cost before tax in USD. </param>
        /// <param name="unitPrice"> Unit Price is the price applicable to you. (your EA or other contract price). </param>
        /// <param name="billingCurrencyCode"> The currency defining the billed cost. </param>
        /// <param name="resourceLocation"> Name of the resource location. </param>
        /// <param name="consumedService"> Consumed service name. Name of the azure resource provider that emits the usage or was purchased. This value is not provided for marketplace usage. </param>
        /// <param name="serviceInfo1"> Service-specific metadata. </param>
        /// <param name="serviceInfo2"> Legacy field with optional service-specific metadata. </param>
        /// <param name="additionalInfo"> Additional details of this usage item. Use this field to get usage line item specific details such as the actual VM Size (ServiceType) or the ratio in which the reservation discount is applied. </param>
        /// <param name="invoiceSectionId"> Identifier of the project that is being charged in the invoice. Not applicable for Microsoft Customer Agreements onboarded by partners. </param>
        /// <param name="invoiceSectionName"> Name of the project that is being charged in the invoice. Not applicable for Microsoft Customer Agreements onboarded by partners. </param>
        /// <param name="costCenter"> The cost center of this department if it is a department and a cost center is provided. </param>
        /// <param name="resourceGroup"> Name of the Azure resource group used for cohesive lifecycle management of resources. </param>
        /// <param name="reservationId"> ARM resource id of the reservation. Only applies to records relevant to reservations. </param>
        /// <param name="reservationName"> User provided display name of the reservation. Last known name for a particular day is populated in the daily data. Only applies to records relevant to reservations. </param>
        /// <param name="productOrderId"> The identifier for the asset or Azure plan name that the subscription belongs to. For example: Azure Plan. For reservations this is the Reservation Order ID. </param>
        /// <param name="productOrderName"> Product Order Name. For reservations this is the SKU that was purchased. </param>
        /// <param name="isAzureCreditEligible"> Determines if the cost is eligible to be paid for using Azure credits. </param>
        /// <param name="term"> Term (in months). Displays the term for the validity of the offer. For example. In case of reserved instances it displays 12 months for yearly term of reserved instance. For one time purchases or recurring purchases, the terms displays 1 month; This is not applicable for Azure consumption. </param>
        /// <param name="publisherName"> Name of the publisher of the service including Microsoft or Third Party publishers. </param>
        /// <param name="publisherType"> Type of publisher that identifies if the publisher is first party, third party reseller or third party agency. </param>
        /// <param name="chargeType"> Indicates a charge represents credits, usage, a Marketplace purchase, a reservation fee, or a refund. </param>
        /// <param name="frequency"> Indicates how frequently this charge will occur. OneTime for purchases which only happen once, Monthly for fees which recur every month, and UsageBased for charges based on how much a service is used. </param>
        /// <param name="costInBillingCurrency"> ExtendedCost or blended cost before tax in billed currency. </param>
        /// <param name="costInPricingCurrency"> ExtendedCost or blended cost before tax in pricing currency to correlate with prices. </param>
        /// <param name="exchangeRate"> Exchange rate used in conversion from pricing currency to billing currency. </param>
        /// <param name="exchangeRateOn"> Date on which exchange rate used in conversion from pricing currency to billing currency. </param>
        /// <param name="invoiceId"> Invoice ID as on the invoice where the specific transaction appears. </param>
        /// <param name="previousInvoiceId"> Reference to an original invoice there is a refund (negative cost). This is populated only when there is a refund. </param>
        /// <param name="pricingCurrencyCode"> Pricing Billing Currency. </param>
        /// <param name="productIdentifier"> Identifier for the product that has accrued charges by consumption or purchase . This is the concatenated key of productId and SkuId in partner center. </param>
        /// <param name="resourceLocationNormalized"> Resource Location Normalized. </param>
        /// <param name="servicePeriodStartOn"> Start date for the rating period when the service usage was rated for charges. The prices for Azure services are determined for the rating period. </param>
        /// <param name="servicePeriodEndOn"> End date for the period when the service usage was rated for charges. The prices for Azure services are determined based on the rating period. </param>
        /// <param name="customerTenantId"> Identifier of the customer's AAD tenant. </param>
        /// <param name="customerName"> Name of the customer's AAD tenant. </param>
        /// <param name="partnerTenantId"> Identifier for the partner's AAD tenant. </param>
        /// <param name="partnerName"> Name of the partner' AAD tenant. </param>
        /// <param name="resellerMpnId"> MPNId for the reseller associated with the subscription. </param>
        /// <param name="resellerName"> Reseller Name. </param>
        /// <param name="publisherId"> Publisher Id. </param>
        /// <param name="marketPrice"> Market Price that's charged for the usage. </param>
        /// <param name="exchangeRatePricingToBilling"> Exchange Rate from pricing currency to billing currency. </param>
        /// <param name="paygCostInBillingCurrency"> The amount of PayG cost before tax in billing currency. </param>
        /// <param name="paygCostInUSD"> The amount of PayG cost before tax in US Dollar currency. </param>
        /// <param name="partnerEarnedCreditRate"> Rate of discount applied if there is a partner earned credit (PEC) based on partner admin link access. </param>
        /// <param name="partnerEarnedCreditApplied"> Flag to indicate if partner earned credit has been applied or not. </param>
        /// <param name="payGPrice"> Retail price for the resource. </param>
        /// <param name="benefitId"> Unique identifier for the applicable benefit. </param>
        /// <param name="benefitName"> Name of the applicable benefit. </param>
        /// <param name="provider"> Identifier for Product Category or Line Of Business, Ex - Azure, Microsoft 365, AWS e.t.c. </param>
        /// <param name="costAllocationRuleName"> Name for Cost Allocation Rule. </param>
        /// <returns> A new <see cref="Models.ConsumptionModernUsageDetail"/> instance for mocking. </returns>
        public static ConsumptionModernUsageDetail ConsumptionModernUsageDetail(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, IReadOnlyDictionary<string, string> tags = null, string billingAccountId = null, decimal? effectivePrice = null, ConsumptionPricingModelType? pricingModel = null, string billingAccountName = null, DateTimeOffset? billingPeriodStartOn = null, DateTimeOffset? billingPeriodEndOn = null, string billingProfileId = null, string billingProfileName = null, string subscriptionGuid = null, string subscriptionName = null, DateTimeOffset? @on = null, string product = null, Guid? meterId = null, string meterName = null, string meterRegion = null, string meterCategory = null, string meterSubCategory = null, string serviceFamily = null, decimal? quantity = null, string unitOfMeasure = null, string instanceName = null, decimal? costInUSD = null, decimal? unitPrice = null, string billingCurrencyCode = null, string resourceLocation = null, string consumedService = null, string serviceInfo1 = null, string serviceInfo2 = null, string additionalInfo = null, string invoiceSectionId = null, string invoiceSectionName = null, string costCenter = null, string resourceGroup = null, string reservationId = null, string reservationName = null, string productOrderId = null, string productOrderName = null, bool? isAzureCreditEligible = null, string term = null, string publisherName = null, string publisherType = null, string chargeType = null, string frequency = null, decimal? costInBillingCurrency = null, decimal? costInPricingCurrency = null, string exchangeRate = null, DateTimeOffset? exchangeRateOn = null, string invoiceId = null, string previousInvoiceId = null, string pricingCurrencyCode = null, string productIdentifier = null, string resourceLocationNormalized = null, DateTimeOffset? servicePeriodStartOn = null, DateTimeOffset? servicePeriodEndOn = null, string customerTenantId = null, string customerName = null, string partnerTenantId = null, string partnerName = null, string resellerMpnId = null, string resellerName = null, string publisherId = null, decimal? marketPrice = null, decimal? exchangeRatePricingToBilling = null, decimal? paygCostInBillingCurrency = null, decimal? paygCostInUSD = null, decimal? partnerEarnedCreditRate = null, string partnerEarnedCreditApplied = null, decimal? payGPrice = null, string benefitId = null, string benefitName = null, string provider = null, string costAllocationRuleName = null)
        {
            tags ??= new Dictionary<string, string>();

            return new ConsumptionModernUsageDetail(
                id,
                name,
                resourceType,
                systemData,
                UsageDetailsKind.Modern,
                etag,
                tags,
                serializedAdditionalRawData: null,
                billingAccountId,
                effectivePrice,
                pricingModel,
                billingAccountName,
                billingPeriodStartOn,
                billingPeriodEndOn,
                billingProfileId,
                billingProfileName,
                subscriptionGuid,
                subscriptionName,
                @on,
                product,
                meterId,
                meterName,
                meterRegion,
                meterCategory,
                meterSubCategory,
                serviceFamily,
                quantity,
                unitOfMeasure,
                instanceName,
                costInUSD,
                unitPrice,
                billingCurrencyCode,
                resourceLocation,
                consumedService,
                serviceInfo1,
                serviceInfo2,
                additionalInfo,
                invoiceSectionId,
                invoiceSectionName,
                costCenter,
                resourceGroup,
                reservationId,
                reservationName,
                productOrderId,
                productOrderName,
                isAzureCreditEligible,
                term,
                publisherName,
                publisherType,
                chargeType,
                frequency,
                costInBillingCurrency,
                costInPricingCurrency,
                exchangeRate,
                exchangeRateOn,
                invoiceId,
                previousInvoiceId,
                pricingCurrencyCode,
                productIdentifier,
                resourceLocationNormalized,
                servicePeriodStartOn,
                servicePeriodEndOn,
                customerTenantId,
                customerName,
                partnerTenantId,
                partnerName,
                resellerMpnId,
                resellerName,
                publisherId,
                marketPrice,
                exchangeRatePricingToBilling,
                paygCostInBillingCurrency,
                paygCostInUSD,
                partnerEarnedCreditRate,
                partnerEarnedCreditApplied,
                payGPrice,
                benefitId,
                benefitName,
                provider,
                costAllocationRuleName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionSkuProperty"/>. </summary>
        /// <param name="name"> The name of sku property. </param>
        /// <param name="value"> The value of sku property. </param>
        /// <returns> A new <see cref="Models.ConsumptionSkuProperty"/> instance for mocking. </returns>
        public static ConsumptionSkuProperty ConsumptionSkuProperty(string name = null, string value = null)
        {
            return new ConsumptionSkuProperty(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionModernReservationRecommendation"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="location"> Resource location. </param>
        /// <param name="sku"> Resource sku. </param>
        /// <param name="etag"> The etag for the resource. </param>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="locationPropertiesLocation"> Resource Location. </param>
        /// <param name="lookBackPeriod"> The number of days of usage to look back for recommendation. </param>
        /// <param name="instanceFlexibilityRatio"> The instance Flexibility Ratio. </param>
        /// <param name="instanceFlexibilityGroup"> The instance Flexibility Group. </param>
        /// <param name="normalizedSize"> The normalized Size. </param>
        /// <param name="recommendedQuantityNormalized"> The recommended Quantity Normalized. </param>
        /// <param name="meterId"> The meter id (GUID). </param>
        /// <param name="term"> RI recommendations in one or three year terms. </param>
        /// <param name="costWithNoReservedInstances"> The total amount of cost without reserved instances. </param>
        /// <param name="recommendedQuantity"> Recommended quality for reserved instances. </param>
        /// <param name="totalCostWithReservedInstances"> The total amount of cost with reserved instances. </param>
        /// <param name="netSavings"> Total estimated savings with reserved instances. </param>
        /// <param name="firstUsageOn"> The usage date for looking back. </param>
        /// <param name="scope"> Shared or single recommendation. </param>
        /// <param name="skuProperties"> List of sku properties. </param>
        /// <param name="skuName"> This is the ARM Sku name. </param>
        /// <returns> A new <see cref="Models.ConsumptionModernReservationRecommendation"/> instance for mocking. </returns>
        public static ConsumptionModernReservationRecommendation ConsumptionModernReservationRecommendation(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, AzureLocation? location = null, string sku = null, ETag? etag = null, IReadOnlyDictionary<string, string> tags = null, string locationPropertiesLocation = null, int? lookBackPeriod = null, float? instanceFlexibilityRatio = null, string instanceFlexibilityGroup = null, string normalizedSize = null, float? recommendedQuantityNormalized = null, Guid? meterId = null, string term = null, ConsumptionAmount costWithNoReservedInstances = null, decimal? recommendedQuantity = null, ConsumptionAmount totalCostWithReservedInstances = null, ConsumptionAmount netSavings = null, DateTimeOffset? firstUsageOn = null, string scope = null, IEnumerable<ConsumptionSkuProperty> skuProperties = null, string skuName = null)
        {
            tags ??= new Dictionary<string, string>();
            skuProperties ??= new List<ConsumptionSkuProperty>();

            return new ConsumptionModernReservationRecommendation(
                id,
                name,
                resourceType,
                systemData,
                ReservationRecommendationKind.Modern,
                location,
                sku,
                etag,
                tags,
                serializedAdditionalRawData: null,
                locationPropertiesLocation,
                lookBackPeriod,
                instanceFlexibilityRatio,
                instanceFlexibilityGroup,
                normalizedSize,
                recommendedQuantityNormalized,
                meterId,
                term,
                costWithNoReservedInstances,
                recommendedQuantity,
                totalCostWithReservedInstances,
                netSavings,
                firstUsageOn,
                scope,
                skuProperties?.ToList(),
                skuName);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionLegacyChargeSummary"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not. </param>
        /// <param name="billingPeriodId"> The id of the billing period resource that the charge belongs to. </param>
        /// <param name="usageStart"> Usage start date. </param>
        /// <param name="usageEnd"> Usage end date. </param>
        /// <param name="azureCharges"> Azure Charges. </param>
        /// <param name="chargesBilledSeparately"> Charges Billed separately. </param>
        /// <param name="marketplaceCharges"> Marketplace Charges. </param>
        /// <param name="currency"> Currency Code. </param>
        /// <returns> A new <see cref="Models.ConsumptionLegacyChargeSummary"/> instance for mocking. </returns>
        public static ConsumptionLegacyChargeSummary ConsumptionLegacyChargeSummary(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, string billingPeriodId = null, string usageStart = null, string usageEnd = null, decimal? azureCharges = null, decimal? chargesBilledSeparately = null, decimal? marketplaceCharges = null, string currency = null)
        {
            return new ConsumptionLegacyChargeSummary(
                id,
                name,
                resourceType,
                systemData,
                ChargeSummaryKind.Legacy,
                etag,
                serializedAdditionalRawData: null,
                billingPeriodId,
                usageStart,
                usageEnd,
                azureCharges,
                chargesBilledSeparately,
                marketplaceCharges,
                currency);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConsumptionModernChargeSummary"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating the latest version or not. </param>
        /// <param name="billingPeriodId"> The id of the billing period resource that the charge belongs to. </param>
        /// <param name="usageStart"> Usage start date. </param>
        /// <param name="usageEnd"> Usage end date. </param>
        /// <param name="azureCharges"> Azure Charges. </param>
        /// <param name="chargesBilledSeparately"> Charges Billed separately. </param>
        /// <param name="marketplaceCharges"> Marketplace Charges. </param>
        /// <param name="billingAccountId"> Billing Account Id. </param>
        /// <param name="billingProfileId"> Billing Profile Id. </param>
        /// <param name="invoiceSectionId"> Invoice Section Id. </param>
        /// <param name="customerId"> Customer Id. </param>
        /// <param name="isInvoiced"> Is charge Invoiced. </param>
        /// <returns> A new <see cref="Models.ConsumptionModernChargeSummary"/> instance for mocking. </returns>
        public static ConsumptionModernChargeSummary ConsumptionModernChargeSummary(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, string billingPeriodId = null, string usageStart = null, string usageEnd = null, ConsumptionAmount azureCharges = null, ConsumptionAmount chargesBilledSeparately = null, ConsumptionAmount marketplaceCharges = null, string billingAccountId = null, string billingProfileId = null, string invoiceSectionId = null, string customerId = null, bool? isInvoiced = null)
        {
            return new ConsumptionModernChargeSummary(
                id,
                name,
                resourceType,
                systemData,
                ChargeSummaryKind.Modern,
                etag,
                serializedAdditionalRawData: null,
                billingPeriodId,
                usageStart,
                usageEnd,
                azureCharges,
                chargesBilledSeparately,
                marketplaceCharges,
                billingAccountId,
                billingProfileId,
                invoiceSectionId,
                customerId,
                isInvoiced);
        }
    }
}
