// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.ConnectedVMwarevSphere
{
    /// <summary>
    /// A Class representing a VmInstanceHybridIdentityMetadata along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="VmInstanceHybridIdentityMetadataResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetVmInstanceHybridIdentityMetadataResource method.
    /// Otherwise you can get one from its parent resource <see cref="VMwareVmInstanceResource"/> using the GetVmInstanceHybridIdentityMetadata method.
    /// </summary>
    public partial class VmInstanceHybridIdentityMetadataResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="VmInstanceHybridIdentityMetadataResource"/> instance. </summary>
        /// <param name="resourceUri"> The resourceUri. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string resourceUri)
        {
            var resourceId = $"{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/hybridIdentityMetadata/default";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _vmInstanceHybridIdentityMetadataVmInstanceHybridIdentityMetadataClientDiagnostics;
        private readonly VmInstanceHybridIdentityMetadataRestOperations _vmInstanceHybridIdentityMetadataVmInstanceHybridIdentityMetadataRestClient;
        private readonly VmInstanceHybridIdentityMetadataData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/hybridIdentityMetadata";

        /// <summary> Initializes a new instance of the <see cref="VmInstanceHybridIdentityMetadataResource"/> class for mocking. </summary>
        protected VmInstanceHybridIdentityMetadataResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="VmInstanceHybridIdentityMetadataResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal VmInstanceHybridIdentityMetadataResource(ArmClient client, VmInstanceHybridIdentityMetadataData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="VmInstanceHybridIdentityMetadataResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal VmInstanceHybridIdentityMetadataResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _vmInstanceHybridIdentityMetadataVmInstanceHybridIdentityMetadataClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ConnectedVMwarevSphere", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string vmInstanceHybridIdentityMetadataVmInstanceHybridIdentityMetadataApiVersion);
            _vmInstanceHybridIdentityMetadataVmInstanceHybridIdentityMetadataRestClient = new VmInstanceHybridIdentityMetadataRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, vmInstanceHybridIdentityMetadataVmInstanceHybridIdentityMetadataApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual VmInstanceHybridIdentityMetadataData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Implements HybridIdentityMetadata GET method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/hybridIdentityMetadata/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VmInstanceHybridIdentityMetadata_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VmInstanceHybridIdentityMetadataResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<VmInstanceHybridIdentityMetadataResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _vmInstanceHybridIdentityMetadataVmInstanceHybridIdentityMetadataClientDiagnostics.CreateScope("VmInstanceHybridIdentityMetadataResource.Get");
            scope.Start();
            try
            {
                var response = await _vmInstanceHybridIdentityMetadataVmInstanceHybridIdentityMetadataRestClient.GetAsync(Id.Parent.Parent, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new VmInstanceHybridIdentityMetadataResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Implements HybridIdentityMetadata GET method.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/hybridIdentityMetadata/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VmInstanceHybridIdentityMetadata_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VmInstanceHybridIdentityMetadataResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<VmInstanceHybridIdentityMetadataResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _vmInstanceHybridIdentityMetadataVmInstanceHybridIdentityMetadataClientDiagnostics.CreateScope("VmInstanceHybridIdentityMetadataResource.Get");
            scope.Start();
            try
            {
                var response = _vmInstanceHybridIdentityMetadataVmInstanceHybridIdentityMetadataRestClient.Get(Id.Parent.Parent, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new VmInstanceHybridIdentityMetadataResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
