// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.ConnectedVMwarevSphere.Models;

namespace Azure.ResourceManager.ConnectedVMwarevSphere
{
    /// <summary>
    /// A Class representing a VMwareVmInstance along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="VMwareVmInstanceResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetVMwareVmInstanceResource method.
    /// Otherwise you can get one from its parent resource <see cref="ArmResource"/> using the GetVMwareVmInstance method.
    /// </summary>
    public partial class VMwareVmInstanceResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="VMwareVmInstanceResource"/> instance. </summary>
        /// <param name="resourceUri"> The resourceUri. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string resourceUri)
        {
            var resourceId = $"{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics;
        private readonly VirtualMachineInstancesRestOperations _vMwareVmInstanceVirtualMachineInstancesRestClient;
        private readonly VMwareVmInstanceData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.ConnectedVMwarevSphere/virtualMachineInstances";

        /// <summary> Initializes a new instance of the <see cref="VMwareVmInstanceResource"/> class for mocking. </summary>
        protected VMwareVmInstanceResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="VMwareVmInstanceResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal VMwareVmInstanceResource(ArmClient client, VMwareVmInstanceData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="VMwareVmInstanceResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal VMwareVmInstanceResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.ConnectedVMwarevSphere", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string vMwareVmInstanceVirtualMachineInstancesApiVersion);
            _vMwareVmInstanceVirtualMachineInstancesRestClient = new VirtualMachineInstancesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, vMwareVmInstanceVirtualMachineInstancesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual VMwareVmInstanceData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary> Gets an object representing a VmInstanceHybridIdentityMetadataResource along with the instance operations that can be performed on it in the VMwareVmInstance. </summary>
        /// <returns> Returns a <see cref="VmInstanceHybridIdentityMetadataResource"/> object. </returns>
        public virtual VmInstanceHybridIdentityMetadataResource GetVmInstanceHybridIdentityMetadata()
        {
            return new VmInstanceHybridIdentityMetadataResource(Client, Id.AppendChildResource("hybridIdentityMetadata", "default"));
        }

        /// <summary> Gets an object representing a VmInstanceGuestAgentResource along with the instance operations that can be performed on it in the VMwareVmInstance. </summary>
        /// <returns> Returns a <see cref="VmInstanceGuestAgentResource"/> object. </returns>
        public virtual VmInstanceGuestAgentResource GetVmInstanceGuestAgent()
        {
            return new VmInstanceGuestAgentResource(Client, Id.AppendChildResource("guestAgents", "default"));
        }

        /// <summary>
        /// Retrieves information about a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VMwareVmInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<VMwareVmInstanceResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("VMwareVmInstanceResource.Get");
            scope.Start();
            try
            {
                var response = await _vMwareVmInstanceVirtualMachineInstancesRestClient.GetAsync(Id.Parent, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new VMwareVmInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Retrieves information about a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VMwareVmInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<VMwareVmInstanceResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("VMwareVmInstanceResource.Get");
            scope.Start();
            try
            {
                var response = _vMwareVmInstanceVirtualMachineInstancesRestClient.Get(Id.Parent, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new VMwareVmInstanceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to delete a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VMwareVmInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="deleteFromHost"> Whether to delete the VM from the vCenter. </param>
        /// <param name="force"> Whether force delete was specified. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, bool? deleteFromHost = null, bool? force = null, CancellationToken cancellationToken = default)
        {
            using var scope = _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("VMwareVmInstanceResource.Delete");
            scope.Start();
            try
            {
                var response = await _vMwareVmInstanceVirtualMachineInstancesRestClient.DeleteAsync(Id.Parent, deleteFromHost, force, cancellationToken).ConfigureAwait(false);
                var operation = new ConnectedVMwarevSphereArmOperation(_vMwareVmInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _vMwareVmInstanceVirtualMachineInstancesRestClient.CreateDeleteRequest(Id.Parent, deleteFromHost, force).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to delete a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VMwareVmInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="deleteFromHost"> Whether to delete the VM from the vCenter. </param>
        /// <param name="force"> Whether force delete was specified. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, bool? deleteFromHost = null, bool? force = null, CancellationToken cancellationToken = default)
        {
            using var scope = _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("VMwareVmInstanceResource.Delete");
            scope.Start();
            try
            {
                var response = _vMwareVmInstanceVirtualMachineInstancesRestClient.Delete(Id.Parent, deleteFromHost, force, cancellationToken);
                var operation = new ConnectedVMwarevSphereArmOperation(_vMwareVmInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _vMwareVmInstanceVirtualMachineInstancesRestClient.CreateDeleteRequest(Id.Parent, deleteFromHost, force).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to update a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VMwareVmInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="patch"> Resource properties to update. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="patch"/> is null. </exception>
        public virtual async Task<ArmOperation<VMwareVmInstanceResource>> UpdateAsync(WaitUntil waitUntil, VMwareVmInstancePatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(patch, nameof(patch));

            using var scope = _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("VMwareVmInstanceResource.Update");
            scope.Start();
            try
            {
                var response = await _vMwareVmInstanceVirtualMachineInstancesRestClient.UpdateAsync(Id.Parent, patch, cancellationToken).ConfigureAwait(false);
                var operation = new ConnectedVMwarevSphereArmOperation<VMwareVmInstanceResource>(new VMwareVmInstanceOperationSource(Client), _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _vMwareVmInstanceVirtualMachineInstancesRestClient.CreateUpdateRequest(Id.Parent, patch).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to update a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VMwareVmInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="patch"> Resource properties to update. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="patch"/> is null. </exception>
        public virtual ArmOperation<VMwareVmInstanceResource> Update(WaitUntil waitUntil, VMwareVmInstancePatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(patch, nameof(patch));

            using var scope = _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("VMwareVmInstanceResource.Update");
            scope.Start();
            try
            {
                var response = _vMwareVmInstanceVirtualMachineInstancesRestClient.Update(Id.Parent, patch, cancellationToken);
                var operation = new ConnectedVMwarevSphereArmOperation<VMwareVmInstanceResource>(new VMwareVmInstanceOperationSource(Client), _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _vMwareVmInstanceVirtualMachineInstancesRestClient.CreateUpdateRequest(Id.Parent, patch).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to create or update a virtual machine instance. Please note some properties can be set only during virtual machine instance creation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VMwareVmInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> Request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<VMwareVmInstanceResource>> CreateOrUpdateAsync(WaitUntil waitUntil, VMwareVmInstanceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("VMwareVmInstanceResource.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _vMwareVmInstanceVirtualMachineInstancesRestClient.CreateOrUpdateAsync(Id.Parent, data, cancellationToken).ConfigureAwait(false);
                var operation = new ConnectedVMwarevSphereArmOperation<VMwareVmInstanceResource>(new VMwareVmInstanceOperationSource(Client), _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _vMwareVmInstanceVirtualMachineInstancesRestClient.CreateCreateOrUpdateRequest(Id.Parent, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to create or update a virtual machine instance. Please note some properties can be set only during virtual machine instance creation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VMwareVmInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> Request payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<VMwareVmInstanceResource> CreateOrUpdate(WaitUntil waitUntil, VMwareVmInstanceData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("VMwareVmInstanceResource.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _vMwareVmInstanceVirtualMachineInstancesRestClient.CreateOrUpdate(Id.Parent, data, cancellationToken);
                var operation = new ConnectedVMwarevSphereArmOperation<VMwareVmInstanceResource>(new VMwareVmInstanceOperationSource(Client), _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _vMwareVmInstanceVirtualMachineInstancesRestClient.CreateCreateOrUpdateRequest(Id.Parent, data).Request, response, OperationFinalStateVia.AzureAsyncOperation);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to power off (stop) a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/stop</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Stop</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VMwareVmInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> Virtualmachine stop action payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> StopAsync(WaitUntil waitUntil, StopVirtualMachineContent content = null, CancellationToken cancellationToken = default)
        {
            using var scope = _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("VMwareVmInstanceResource.Stop");
            scope.Start();
            try
            {
                var response = await _vMwareVmInstanceVirtualMachineInstancesRestClient.StopAsync(Id.Parent, content, cancellationToken).ConfigureAwait(false);
                var operation = new ConnectedVMwarevSphereArmOperation(_vMwareVmInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _vMwareVmInstanceVirtualMachineInstancesRestClient.CreateStopRequest(Id.Parent, content).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to power off (stop) a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/stop</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Stop</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VMwareVmInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> Virtualmachine stop action payload. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Stop(WaitUntil waitUntil, StopVirtualMachineContent content = null, CancellationToken cancellationToken = default)
        {
            using var scope = _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("VMwareVmInstanceResource.Stop");
            scope.Start();
            try
            {
                var response = _vMwareVmInstanceVirtualMachineInstancesRestClient.Stop(Id.Parent, content, cancellationToken);
                var operation = new ConnectedVMwarevSphereArmOperation(_vMwareVmInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _vMwareVmInstanceVirtualMachineInstancesRestClient.CreateStopRequest(Id.Parent, content).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to start a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/start</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Start</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VMwareVmInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> StartAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("VMwareVmInstanceResource.Start");
            scope.Start();
            try
            {
                var response = await _vMwareVmInstanceVirtualMachineInstancesRestClient.StartAsync(Id.Parent, cancellationToken).ConfigureAwait(false);
                var operation = new ConnectedVMwarevSphereArmOperation(_vMwareVmInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _vMwareVmInstanceVirtualMachineInstancesRestClient.CreateStartRequest(Id.Parent).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to start a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/start</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Start</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VMwareVmInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Start(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("VMwareVmInstanceResource.Start");
            scope.Start();
            try
            {
                var response = _vMwareVmInstanceVirtualMachineInstancesRestClient.Start(Id.Parent, cancellationToken);
                var operation = new ConnectedVMwarevSphereArmOperation(_vMwareVmInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _vMwareVmInstanceVirtualMachineInstancesRestClient.CreateStartRequest(Id.Parent).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to restart a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/restart</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Restart</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VMwareVmInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> RestartAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("VMwareVmInstanceResource.Restart");
            scope.Start();
            try
            {
                var response = await _vMwareVmInstanceVirtualMachineInstancesRestClient.RestartAsync(Id.Parent, cancellationToken).ConfigureAwait(false);
                var operation = new ConnectedVMwarevSphereArmOperation(_vMwareVmInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _vMwareVmInstanceVirtualMachineInstancesRestClient.CreateRestartRequest(Id.Parent).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// The operation to restart a virtual machine instance.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceUri}/providers/Microsoft.ConnectedVMwarevSphere/virtualMachineInstances/default/restart</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>VirtualMachineInstances_Restart</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-12-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="VMwareVmInstanceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Restart(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _vMwareVmInstanceVirtualMachineInstancesClientDiagnostics.CreateScope("VMwareVmInstanceResource.Restart");
            scope.Start();
            try
            {
                var response = _vMwareVmInstanceVirtualMachineInstancesRestClient.Restart(Id.Parent, cancellationToken);
                var operation = new ConnectedVMwarevSphereArmOperation(_vMwareVmInstanceVirtualMachineInstancesClientDiagnostics, Pipeline, _vMwareVmInstanceVirtualMachineInstancesRestClient.CreateRestartRequest(Id.Parent).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
