// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.ConnectedVMwarevSphere.Models;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.ConnectedVMwarevSphere
{
    /// <summary>
    /// A class representing the VMwareVmInstance data model.
    /// Define the virtualMachineInstance.
    /// </summary>
    public partial class VMwareVmInstanceData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VMwareVmInstanceData"/>. </summary>
        public VMwareVmInstanceData()
        {
            Statuses = new ChangeTrackingList<VMwareResourceStatus>();
        }

        /// <summary> Initializes a new instance of <see cref="VMwareVmInstanceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="extendedLocation"> Gets or sets the extended location. </param>
        /// <param name="placementProfile"> Placement properties. </param>
        /// <param name="osProfile"> OS properties. </param>
        /// <param name="hardwareProfile"> Hardware properties. </param>
        /// <param name="networkProfile"> Network properties. </param>
        /// <param name="storageProfile"> Storage properties. </param>
        /// <param name="securityProfile"> Gets the security profile. </param>
        /// <param name="infrastructureProfile"> Gets the infrastructure profile. </param>
        /// <param name="powerState"> Gets the power state of the virtual machine. </param>
        /// <param name="statuses"> The resource status information. </param>
        /// <param name="provisioningState"> Gets the provisioning state. </param>
        /// <param name="resourceUid"> Gets or sets a unique identifier for the vm resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VMwareVmInstanceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ExtendedLocation extendedLocation, PlacementProfile placementProfile, OSProfileForVmInstance osProfile, VmInstanceHardwareProfile hardwareProfile, VMwareNetworkProfile networkProfile, VMwareStorageProfile storageProfile, SecurityProfile securityProfile, VCenterInfrastructureProfile infrastructureProfile, string powerState, IReadOnlyList<VMwareResourceStatus> statuses, VMwareResourceProvisioningState? provisioningState, string resourceUid, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ExtendedLocation = extendedLocation;
            PlacementProfile = placementProfile;
            OSProfile = osProfile;
            HardwareProfile = hardwareProfile;
            NetworkProfile = networkProfile;
            StorageProfile = storageProfile;
            SecurityProfile = securityProfile;
            InfrastructureProfile = infrastructureProfile;
            PowerState = powerState;
            Statuses = statuses;
            ProvisioningState = provisioningState;
            ResourceUid = resourceUid;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the extended location. </summary>
        public ExtendedLocation ExtendedLocation { get; set; }
        /// <summary> Placement properties. </summary>
        public PlacementProfile PlacementProfile { get; set; }
        /// <summary> OS properties. </summary>
        public OSProfileForVmInstance OSProfile { get; set; }
        /// <summary> Hardware properties. </summary>
        public VmInstanceHardwareProfile HardwareProfile { get; set; }
        /// <summary> Network properties. </summary>
        internal VMwareNetworkProfile NetworkProfile { get; set; }
        /// <summary> Gets or sets the list of network interfaces associated with the virtual machine. </summary>
        public IList<VMwareNetworkInterface> NetworkInterfaces
        {
            get
            {
                if (NetworkProfile is null)
                    NetworkProfile = new VMwareNetworkProfile();
                return NetworkProfile.NetworkInterfaces;
            }
        }

        /// <summary> Storage properties. </summary>
        public VMwareStorageProfile StorageProfile { get; set; }
        /// <summary> Gets the security profile. </summary>
        internal SecurityProfile SecurityProfile { get; set; }
        /// <summary> Specifies whether secure boot should be enabled on the virtual machine. </summary>
        public bool? SecureBootEnabled
        {
            get => SecurityProfile is null ? default : SecurityProfile.SecureBootEnabled;
            set
            {
                if (SecurityProfile is null)
                    SecurityProfile = new SecurityProfile();
                SecurityProfile.SecureBootEnabled = value;
            }
        }

        /// <summary> Gets the infrastructure profile. </summary>
        public VCenterInfrastructureProfile InfrastructureProfile { get; set; }
        /// <summary> Gets the power state of the virtual machine. </summary>
        public string PowerState { get; }
        /// <summary> The resource status information. </summary>
        public IReadOnlyList<VMwareResourceStatus> Statuses { get; }
        /// <summary> Gets the provisioning state. </summary>
        public VMwareResourceProvisioningState? ProvisioningState { get; }
        /// <summary> Gets or sets a unique identifier for the vm resource. </summary>
        public string ResourceUid { get; }
    }
}
