// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    /// <summary> Username / Password Credentials to connect to guest. </summary>
    public partial class VmInstanceGuestCredential
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VmInstanceGuestCredential"/>. </summary>
        public VmInstanceGuestCredential()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VmInstanceGuestCredential"/>. </summary>
        /// <param name="username"> Gets or sets username to connect with the guest. </param>
        /// <param name="password"> Gets or sets the password to connect with the guest. </param>
        /// <param name="privateKey"> Private key used to authenticate to a virtual machine through ssh. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VmInstanceGuestCredential(string username, string password, string privateKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Username = username;
            Password = password;
            PrivateKey = privateKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets username to connect with the guest. </summary>
        public string Username { get; set; }
        /// <summary> Gets or sets the password to connect with the guest. </summary>
        public string Password { get; set; }
        /// <summary> Private key used to authenticate to a virtual machine through ssh. </summary>
        public string PrivateKey { get; set; }
    }
}
