// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    public partial class VirtualScsiController : IUtf8JsonSerializable, IJsonModel<VirtualScsiController>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<VirtualScsiController>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<VirtualScsiController>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VirtualScsiController>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VirtualScsiController)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ScsiControllerType))
            {
                writer.WritePropertyName("type"u8);
                writer.WriteStringValue(ScsiControllerType.Value.ToString());
            }
            if (Optional.IsDefined(ControllerKey))
            {
                writer.WritePropertyName("controllerKey"u8);
                writer.WriteNumberValue(ControllerKey.Value);
            }
            if (Optional.IsDefined(BusNumber))
            {
                writer.WritePropertyName("busNumber"u8);
                writer.WriteNumberValue(BusNumber.Value);
            }
            if (Optional.IsDefined(ScsiCtlrUnitNumber))
            {
                writer.WritePropertyName("scsiCtlrUnitNumber"u8);
                writer.WriteNumberValue(ScsiCtlrUnitNumber.Value);
            }
            if (Optional.IsDefined(Sharing))
            {
                writer.WritePropertyName("sharing"u8);
                writer.WriteStringValue(Sharing.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        VirtualScsiController IJsonModel<VirtualScsiController>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VirtualScsiController>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VirtualScsiController)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeVirtualScsiController(document.RootElement, options);
        }

        internal static VirtualScsiController DeserializeVirtualScsiController(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ScsiControllerType? type = default;
            int? controllerKey = default;
            int? busNumber = default;
            int? scsiCtlrUnitNumber = default;
            VirtualScsiSharing? sharing = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new ScsiControllerType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("controllerKey"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    controllerKey = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("busNumber"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    busNumber = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("scsiCtlrUnitNumber"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    scsiCtlrUnitNumber = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("sharing"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sharing = new VirtualScsiSharing(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new VirtualScsiController(
                type,
                controllerKey,
                busNumber,
                scsiCtlrUnitNumber,
                sharing,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<VirtualScsiController>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VirtualScsiController>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(VirtualScsiController)} does not support writing '{options.Format}' format.");
            }
        }

        VirtualScsiController IPersistableModel<VirtualScsiController>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VirtualScsiController>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeVirtualScsiController(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(VirtualScsiController)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<VirtualScsiController>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
