// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    /// <summary> Specifies the Windows Configuration settings for the virtual machine. </summary>
    public partial class VMwareVmWindowsConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VMwareVmWindowsConfiguration"/>. </summary>
        public VMwareVmWindowsConfiguration()
        {
            FirstLogonCommands = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="VMwareVmWindowsConfiguration"/>. </summary>
        /// <param name="fullName"> Sets full name of the owner of the vm. </param>
        /// <param name="orgName"> Sets org name to which the owner of the vm belongs. </param>
        /// <param name="domainName"> Sets domain name that vm should join. </param>
        /// <param name="domainUsername"> Sets domain username. </param>
        /// <param name="domainUserPassword"> Sets domain user password. </param>
        /// <param name="workGroupName"> Sets work group name that vm should join. </param>
        /// <param name="productId"> Sets product id of the vm. </param>
        /// <param name="isAutoLogon"> Sets a value indicating whether auto logon is enabled. </param>
        /// <param name="autoLogonCount"> Sets auto logon count. </param>
        /// <param name="timeZone"> Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time". Time zone name correspond to time zones listed at Microsoft Time Zone name values(https://learn.microsoft.com/en-us/previous-versions/windows/embedded/ms912391(v=winembedded.11)). </param>
        /// <param name="firstLogonCommands"> Sets first logon commands. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VMwareVmWindowsConfiguration(string fullName, string orgName, string domainName, string domainUsername, string domainUserPassword, string workGroupName, string productId, bool? isAutoLogon, int? autoLogonCount, string timeZone, IList<string> firstLogonCommands, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FullName = fullName;
            OrgName = orgName;
            DomainName = domainName;
            DomainUsername = domainUsername;
            DomainUserPassword = domainUserPassword;
            WorkGroupName = workGroupName;
            ProductId = productId;
            IsAutoLogon = isAutoLogon;
            AutoLogonCount = autoLogonCount;
            TimeZone = timeZone;
            FirstLogonCommands = firstLogonCommands;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Sets full name of the owner of the vm. </summary>
        public string FullName { get; set; }
        /// <summary> Sets org name to which the owner of the vm belongs. </summary>
        public string OrgName { get; set; }
        /// <summary> Sets domain name that vm should join. </summary>
        public string DomainName { get; set; }
        /// <summary> Sets domain username. </summary>
        public string DomainUsername { get; set; }
        /// <summary> Sets domain user password. </summary>
        public string DomainUserPassword { get; set; }
        /// <summary> Sets work group name that vm should join. </summary>
        public string WorkGroupName { get; set; }
        /// <summary> Sets product id of the vm. </summary>
        public string ProductId { get; set; }
        /// <summary> Sets a value indicating whether auto logon is enabled. </summary>
        public bool? IsAutoLogon { get; set; }
        /// <summary> Sets auto logon count. </summary>
        public int? AutoLogonCount { get; set; }
        /// <summary> Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time". Time zone name correspond to time zones listed at Microsoft Time Zone name values(https://learn.microsoft.com/en-us/previous-versions/windows/embedded/ms912391(v=winembedded.11)). </summary>
        public string TimeZone { get; set; }
        /// <summary> Sets first logon commands. </summary>
        public IList<string> FirstLogonCommands { get; }
    }
}
