// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    /// <summary> Defines the virtualMachineInstanceUpdate. </summary>
    public partial class VMwareVmInstancePatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VMwareVmInstancePatch"/>. </summary>
        public VMwareVmInstancePatch()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VMwareVmInstancePatch"/>. </summary>
        /// <param name="hardwareProfile"> Specifies the hardware settings for the virtual machine. </param>
        /// <param name="storageProfile"> Specifies the storage settings for the virtual machine disks. </param>
        /// <param name="networkProfile"> Specifies the network interfaces of the virtual machine. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VMwareVmInstancePatch(VmInstanceHardwareProfile hardwareProfile, StorageProfileUpdate storageProfile, VMwareNetworkProfileUpdate networkProfile, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            HardwareProfile = hardwareProfile;
            StorageProfile = storageProfile;
            NetworkProfile = networkProfile;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Specifies the hardware settings for the virtual machine. </summary>
        public VmInstanceHardwareProfile HardwareProfile { get; set; }
        /// <summary> Specifies the storage settings for the virtual machine disks. </summary>
        internal StorageProfileUpdate StorageProfile { get; set; }
        /// <summary> Gets or sets the list of virtual disks associated with the virtual machine. </summary>
        public IList<VMwareVirtualDiskUpdate> StorageDisks
        {
            get
            {
                if (StorageProfile is null)
                    StorageProfile = new StorageProfileUpdate();
                return StorageProfile.Disks;
            }
        }

        /// <summary> Specifies the network interfaces of the virtual machine. </summary>
        internal VMwareNetworkProfileUpdate NetworkProfile { get; set; }
        /// <summary> Gets or sets the list of network interfaces associated with the virtual machine. </summary>
        public IList<VMwareNetworkInterfaceUpdate> NetworkInterfaces
        {
            get
            {
                if (NetworkProfile is null)
                    NetworkProfile = new VMwareNetworkProfileUpdate();
                return NetworkProfile.NetworkInterfaces;
            }
        }
    }
}
