// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    /// <summary> Defines the virtual disk update. </summary>
    public partial class VMwareVirtualDiskUpdate
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VMwareVirtualDiskUpdate"/>. </summary>
        public VMwareVirtualDiskUpdate()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VMwareVirtualDiskUpdate"/>. </summary>
        /// <param name="name"> Gets or sets the name of the virtual disk. </param>
        /// <param name="diskSizeGB"> Gets or sets the disk total size. </param>
        /// <param name="deviceKey"> Gets or sets the device key value. </param>
        /// <param name="diskMode"> Gets or sets the disk mode. </param>
        /// <param name="controllerKey"> Gets or sets the controller id. </param>
        /// <param name="unitNumber"> Gets or sets the unit number of the disk on the controller. </param>
        /// <param name="deviceName"> Gets or sets the device name. </param>
        /// <param name="diskType"> Gets or sets the disk backing type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VMwareVirtualDiskUpdate(string name, int? diskSizeGB, int? deviceKey, VMwareDiskMode? diskMode, int? controllerKey, int? unitNumber, string deviceName, VMwareDiskType? diskType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            DiskSizeGB = diskSizeGB;
            DeviceKey = deviceKey;
            DiskMode = diskMode;
            ControllerKey = controllerKey;
            UnitNumber = unitNumber;
            DeviceName = deviceName;
            DiskType = diskType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the name of the virtual disk. </summary>
        public string Name { get; set; }
        /// <summary> Gets or sets the disk total size. </summary>
        public int? DiskSizeGB { get; set; }
        /// <summary> Gets or sets the device key value. </summary>
        public int? DeviceKey { get; set; }
        /// <summary> Gets or sets the disk mode. </summary>
        public VMwareDiskMode? DiskMode { get; set; }
        /// <summary> Gets or sets the controller id. </summary>
        public int? ControllerKey { get; set; }
        /// <summary> Gets or sets the unit number of the disk on the controller. </summary>
        public int? UnitNumber { get; set; }
        /// <summary> Gets or sets the device name. </summary>
        public string DeviceName { get; set; }
        /// <summary> Gets or sets the disk backing type. </summary>
        public VMwareDiskType? DiskType { get; set; }
    }
}
