// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    /// <summary> The current deployment state of resource. </summary>
    public readonly partial struct VMwareResourceProvisioningState : IEquatable<VMwareResourceProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VMwareResourceProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VMwareResourceProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningValue = "Provisioning";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string AcceptedValue = "Accepted";
        private const string CreatedValue = "Created";

        /// <summary> Succeeded. </summary>
        public static VMwareResourceProvisioningState Succeeded { get; } = new VMwareResourceProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static VMwareResourceProvisioningState Failed { get; } = new VMwareResourceProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static VMwareResourceProvisioningState Canceled { get; } = new VMwareResourceProvisioningState(CanceledValue);
        /// <summary> Provisioning. </summary>
        public static VMwareResourceProvisioningState Provisioning { get; } = new VMwareResourceProvisioningState(ProvisioningValue);
        /// <summary> Updating. </summary>
        public static VMwareResourceProvisioningState Updating { get; } = new VMwareResourceProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static VMwareResourceProvisioningState Deleting { get; } = new VMwareResourceProvisioningState(DeletingValue);
        /// <summary> Accepted. </summary>
        public static VMwareResourceProvisioningState Accepted { get; } = new VMwareResourceProvisioningState(AcceptedValue);
        /// <summary> Created. </summary>
        public static VMwareResourceProvisioningState Created { get; } = new VMwareResourceProvisioningState(CreatedValue);
        /// <summary> Determines if two <see cref="VMwareResourceProvisioningState"/> values are the same. </summary>
        public static bool operator ==(VMwareResourceProvisioningState left, VMwareResourceProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VMwareResourceProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(VMwareResourceProvisioningState left, VMwareResourceProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VMwareResourceProvisioningState"/>. </summary>
        public static implicit operator VMwareResourceProvisioningState(string value) => new VMwareResourceProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VMwareResourceProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VMwareResourceProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
