// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    /// <summary> Defines the network interface update. </summary>
    public partial class VMwareNetworkInterfaceUpdate
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VMwareNetworkInterfaceUpdate"/>. </summary>
        public VMwareNetworkInterfaceUpdate()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VMwareNetworkInterfaceUpdate"/>. </summary>
        /// <param name="name"> Gets or sets the name of the network interface. </param>
        /// <param name="networkId"> Gets or sets the ARM Id of the network resource to connect the virtual machine. </param>
        /// <param name="nicType"> NIC type. </param>
        /// <param name="powerOnBoot"> Gets or sets the power on boot. </param>
        /// <param name="deviceKey"> Gets or sets the device key value. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VMwareNetworkInterfaceUpdate(string name, string networkId, VMwareNicType? nicType, PowerOnBootOption? powerOnBoot, int? deviceKey, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            NetworkId = networkId;
            NicType = nicType;
            PowerOnBoot = powerOnBoot;
            DeviceKey = deviceKey;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the name of the network interface. </summary>
        public string Name { get; set; }
        /// <summary> Gets or sets the ARM Id of the network resource to connect the virtual machine. </summary>
        public string NetworkId { get; set; }
        /// <summary> NIC type. </summary>
        public VMwareNicType? NicType { get; set; }
        /// <summary> Gets or sets the power on boot. </summary>
        public PowerOnBootOption? PowerOnBoot { get; set; }
        /// <summary> Gets or sets the device key value. </summary>
        public int? DeviceKey { get; set; }
    }
}
