// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    public partial class VMwareNetworkInterface : IUtf8JsonSerializable, IJsonModel<VMwareNetworkInterface>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<VMwareNetworkInterface>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<VMwareNetworkInterface>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VMwareNetworkInterface>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VMwareNetworkInterface)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Name))
            {
                writer.WritePropertyName("name"u8);
                writer.WriteStringValue(Name);
            }
            if (options.Format != "W" && Optional.IsDefined(Label))
            {
                writer.WritePropertyName("label"u8);
                writer.WriteStringValue(Label);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(IPAddresses))
            {
                writer.WritePropertyName("ipAddresses"u8);
                writer.WriteStartArray();
                foreach (var item in IPAddresses)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(MacAddress))
            {
                writer.WritePropertyName("macAddress"u8);
                writer.WriteStringValue(MacAddress);
            }
            if (Optional.IsDefined(NetworkId))
            {
                writer.WritePropertyName("networkId"u8);
                writer.WriteStringValue(NetworkId);
            }
            if (Optional.IsDefined(NicType))
            {
                writer.WritePropertyName("nicType"u8);
                writer.WriteStringValue(NicType.Value.ToString());
            }
            if (Optional.IsDefined(PowerOnBoot))
            {
                writer.WritePropertyName("powerOnBoot"u8);
                writer.WriteStringValue(PowerOnBoot.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(NetworkMoRefId))
            {
                writer.WritePropertyName("networkMoRefId"u8);
                writer.WriteStringValue(NetworkMoRefId);
            }
            if (options.Format != "W" && Optional.IsDefined(NetworkMoName))
            {
                writer.WritePropertyName("networkMoName"u8);
                writer.WriteStringValue(NetworkMoName);
            }
            if (Optional.IsDefined(DeviceKey))
            {
                writer.WritePropertyName("deviceKey"u8);
                writer.WriteNumberValue(DeviceKey.Value);
            }
            if (Optional.IsDefined(IPSettings))
            {
                writer.WritePropertyName("ipSettings"u8);
                writer.WriteObjectValue(IPSettings, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        VMwareNetworkInterface IJsonModel<VMwareNetworkInterface>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VMwareNetworkInterface>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VMwareNetworkInterface)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeVMwareNetworkInterface(document.RootElement, options);
        }

        internal static VMwareNetworkInterface DeserializeVMwareNetworkInterface(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string label = default;
            IReadOnlyList<string> ipAddresses = default;
            string macAddress = default;
            string networkId = default;
            VMwareNicType? nicType = default;
            PowerOnBootOption? powerOnBoot = default;
            string networkMoRefId = default;
            string networkMoName = default;
            int? deviceKey = default;
            NicIPSettings ipSettings = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("label"u8))
                {
                    label = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ipAddresses"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    ipAddresses = array;
                    continue;
                }
                if (property.NameEquals("macAddress"u8))
                {
                    macAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("networkId"u8))
                {
                    networkId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("nicType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nicType = new VMwareNicType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("powerOnBoot"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    powerOnBoot = new PowerOnBootOption(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("networkMoRefId"u8))
                {
                    networkMoRefId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("networkMoName"u8))
                {
                    networkMoName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("deviceKey"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    deviceKey = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("ipSettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ipSettings = NicIPSettings.DeserializeNicIPSettings(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new VMwareNetworkInterface(
                name,
                label,
                ipAddresses ?? new ChangeTrackingList<string>(),
                macAddress,
                networkId,
                nicType,
                powerOnBoot,
                networkMoRefId,
                networkMoName,
                deviceKey,
                ipSettings,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<VMwareNetworkInterface>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VMwareNetworkInterface>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(VMwareNetworkInterface)} does not support writing '{options.Format}' format.");
            }
        }

        VMwareNetworkInterface IPersistableModel<VMwareNetworkInterface>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VMwareNetworkInterface>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeVMwareNetworkInterface(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(VMwareNetworkInterface)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<VMwareNetworkInterface>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
