// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    /// <summary> Firmware type. </summary>
    public readonly partial struct VMwareFirmwareType : IEquatable<VMwareFirmwareType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VMwareFirmwareType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VMwareFirmwareType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BiosValue = "bios";
        private const string EfiValue = "efi";

        /// <summary> bios. </summary>
        public static VMwareFirmwareType Bios { get; } = new VMwareFirmwareType(BiosValue);
        /// <summary> efi. </summary>
        public static VMwareFirmwareType Efi { get; } = new VMwareFirmwareType(EfiValue);
        /// <summary> Determines if two <see cref="VMwareFirmwareType"/> values are the same. </summary>
        public static bool operator ==(VMwareFirmwareType left, VMwareFirmwareType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VMwareFirmwareType"/> values are not the same. </summary>
        public static bool operator !=(VMwareFirmwareType left, VMwareFirmwareType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VMwareFirmwareType"/>. </summary>
        public static implicit operator VMwareFirmwareType(string value) => new VMwareFirmwareType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VMwareFirmwareType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VMwareFirmwareType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
