// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    /// <summary> Defines the different types of disks. </summary>
    public readonly partial struct VMwareDiskType : IEquatable<VMwareDiskType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VMwareDiskType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VMwareDiskType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FlatValue = "flat";
        private const string PmemValue = "pmem";
        private const string RawphysicalValue = "rawphysical";
        private const string RawvirtualValue = "rawvirtual";
        private const string SparseValue = "sparse";
        private const string SesparseValue = "sesparse";
        private const string UnknownValue = "unknown";

        /// <summary> flat. </summary>
        public static VMwareDiskType Flat { get; } = new VMwareDiskType(FlatValue);
        /// <summary> pmem. </summary>
        public static VMwareDiskType Pmem { get; } = new VMwareDiskType(PmemValue);
        /// <summary> rawphysical. </summary>
        public static VMwareDiskType Rawphysical { get; } = new VMwareDiskType(RawphysicalValue);
        /// <summary> rawvirtual. </summary>
        public static VMwareDiskType Rawvirtual { get; } = new VMwareDiskType(RawvirtualValue);
        /// <summary> sparse. </summary>
        public static VMwareDiskType Sparse { get; } = new VMwareDiskType(SparseValue);
        /// <summary> sesparse. </summary>
        public static VMwareDiskType Sesparse { get; } = new VMwareDiskType(SesparseValue);
        /// <summary> unknown. </summary>
        public static VMwareDiskType Unknown { get; } = new VMwareDiskType(UnknownValue);
        /// <summary> Determines if two <see cref="VMwareDiskType"/> values are the same. </summary>
        public static bool operator ==(VMwareDiskType left, VMwareDiskType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VMwareDiskType"/> values are not the same. </summary>
        public static bool operator !=(VMwareDiskType left, VMwareDiskType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VMwareDiskType"/>. </summary>
        public static implicit operator VMwareDiskType(string value) => new VMwareDiskType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VMwareDiskType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VMwareDiskType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
