// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    /// <summary> Defines the different types of disk modes. </summary>
    public readonly partial struct VMwareDiskMode : IEquatable<VMwareDiskMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VMwareDiskMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VMwareDiskMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PersistentValue = "persistent";
        private const string IndependentPersistentValue = "independent_persistent";
        private const string IndependentNonpersistentValue = "independent_nonpersistent";

        /// <summary> persistent. </summary>
        public static VMwareDiskMode Persistent { get; } = new VMwareDiskMode(PersistentValue);
        /// <summary> independent_persistent. </summary>
        public static VMwareDiskMode IndependentPersistent { get; } = new VMwareDiskMode(IndependentPersistentValue);
        /// <summary> independent_nonpersistent. </summary>
        public static VMwareDiskMode IndependentNonpersistent { get; } = new VMwareDiskMode(IndependentNonpersistentValue);
        /// <summary> Determines if two <see cref="VMwareDiskMode"/> values are the same. </summary>
        public static bool operator ==(VMwareDiskMode left, VMwareDiskMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VMwareDiskMode"/> values are not the same. </summary>
        public static bool operator !=(VMwareDiskMode left, VMwareDiskMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VMwareDiskMode"/>. </summary>
        public static implicit operator VMwareDiskMode(string value) => new VMwareDiskMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VMwareDiskMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VMwareDiskMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
