// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    /// <summary> Specifies the vCenter infrastructure specific settings for the virtual machine. </summary>
    public partial class VCenterInfrastructureProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VCenterInfrastructureProfile"/>. </summary>
        public VCenterInfrastructureProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="VCenterInfrastructureProfile"/>. </summary>
        /// <param name="templateId"> Gets or sets the ARM Id of the template resource to deploy the virtual machine. </param>
        /// <param name="vCenterId"> Gets or sets the ARM Id of the vCenter resource in which this resource pool resides. </param>
        /// <param name="moRefId"> Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual machine. </param>
        /// <param name="inventoryItemId"> Gets or sets the inventory Item ID for the virtual machine. </param>
        /// <param name="moName"> Gets or sets the vCenter Managed Object name for the virtual machine. </param>
        /// <param name="folderPath"> Gets or sets the folder path of the vm. </param>
        /// <param name="instanceUuid"> Gets or sets the instance uuid of the vm. </param>
        /// <param name="smbiosUuid"> Gets or sets the SMBIOS UUID of the vm. </param>
        /// <param name="firmwareType"> Firmware type. </param>
        /// <param name="customResourceName"> Gets the name of the corresponding resource in Kubernetes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VCenterInfrastructureProfile(string templateId, string vCenterId, string moRefId, string inventoryItemId, string moName, string folderPath, string instanceUuid, string smbiosUuid, VMwareFirmwareType? firmwareType, string customResourceName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TemplateId = templateId;
            VCenterId = vCenterId;
            MoRefId = moRefId;
            InventoryItemId = inventoryItemId;
            MoName = moName;
            FolderPath = folderPath;
            InstanceUuid = instanceUuid;
            SmbiosUuid = smbiosUuid;
            FirmwareType = firmwareType;
            CustomResourceName = customResourceName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the ARM Id of the template resource to deploy the virtual machine. </summary>
        public string TemplateId { get; set; }
        /// <summary> Gets or sets the ARM Id of the vCenter resource in which this resource pool resides. </summary>
        public string VCenterId { get; set; }
        /// <summary> Gets or sets the vCenter MoRef (Managed Object Reference) ID for the virtual machine. </summary>
        public string MoRefId { get; }
        /// <summary> Gets or sets the inventory Item ID for the virtual machine. </summary>
        public string InventoryItemId { get; set; }
        /// <summary> Gets or sets the vCenter Managed Object name for the virtual machine. </summary>
        public string MoName { get; }
        /// <summary> Gets or sets the folder path of the vm. </summary>
        public string FolderPath { get; }
        /// <summary> Gets or sets the instance uuid of the vm. </summary>
        public string InstanceUuid { get; }
        /// <summary> Gets or sets the SMBIOS UUID of the vm. </summary>
        public string SmbiosUuid { get; set; }
        /// <summary> Firmware type. </summary>
        public VMwareFirmwareType? FirmwareType { get; set; }
        /// <summary> Gets the name of the corresponding resource in Kubernetes. </summary>
        public string CustomResourceName { get; }
    }
}
