// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    public partial class VCenterInfrastructureProfile : IUtf8JsonSerializable, IJsonModel<VCenterInfrastructureProfile>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<VCenterInfrastructureProfile>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<VCenterInfrastructureProfile>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VCenterInfrastructureProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VCenterInfrastructureProfile)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(TemplateId))
            {
                writer.WritePropertyName("templateId"u8);
                writer.WriteStringValue(TemplateId);
            }
            if (Optional.IsDefined(VCenterId))
            {
                writer.WritePropertyName("vCenterId"u8);
                writer.WriteStringValue(VCenterId);
            }
            if (options.Format != "W" && Optional.IsDefined(MoRefId))
            {
                writer.WritePropertyName("moRefId"u8);
                writer.WriteStringValue(MoRefId);
            }
            if (Optional.IsDefined(InventoryItemId))
            {
                writer.WritePropertyName("inventoryItemId"u8);
                writer.WriteStringValue(InventoryItemId);
            }
            if (options.Format != "W" && Optional.IsDefined(MoName))
            {
                writer.WritePropertyName("moName"u8);
                writer.WriteStringValue(MoName);
            }
            if (options.Format != "W" && Optional.IsDefined(FolderPath))
            {
                writer.WritePropertyName("folderPath"u8);
                writer.WriteStringValue(FolderPath);
            }
            if (options.Format != "W" && Optional.IsDefined(InstanceUuid))
            {
                writer.WritePropertyName("instanceUuid"u8);
                writer.WriteStringValue(InstanceUuid);
            }
            if (Optional.IsDefined(SmbiosUuid))
            {
                writer.WritePropertyName("smbiosUuid"u8);
                writer.WriteStringValue(SmbiosUuid);
            }
            if (Optional.IsDefined(FirmwareType))
            {
                writer.WritePropertyName("firmwareType"u8);
                writer.WriteStringValue(FirmwareType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(CustomResourceName))
            {
                writer.WritePropertyName("customResourceName"u8);
                writer.WriteStringValue(CustomResourceName);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        VCenterInfrastructureProfile IJsonModel<VCenterInfrastructureProfile>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VCenterInfrastructureProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(VCenterInfrastructureProfile)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeVCenterInfrastructureProfile(document.RootElement, options);
        }

        internal static VCenterInfrastructureProfile DeserializeVCenterInfrastructureProfile(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string templateId = default;
            string vCenterId = default;
            string moRefId = default;
            string inventoryItemId = default;
            string moName = default;
            string folderPath = default;
            string instanceUuid = default;
            string smbiosUuid = default;
            VMwareFirmwareType? firmwareType = default;
            string customResourceName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("templateId"u8))
                {
                    templateId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("vCenterId"u8))
                {
                    vCenterId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("moRefId"u8))
                {
                    moRefId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("inventoryItemId"u8))
                {
                    inventoryItemId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("moName"u8))
                {
                    moName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("folderPath"u8))
                {
                    folderPath = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("instanceUuid"u8))
                {
                    instanceUuid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("smbiosUuid"u8))
                {
                    smbiosUuid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("firmwareType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    firmwareType = new VMwareFirmwareType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("customResourceName"u8))
                {
                    customResourceName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new VCenterInfrastructureProfile(
                templateId,
                vCenterId,
                moRefId,
                inventoryItemId,
                moName,
                folderPath,
                instanceUuid,
                smbiosUuid,
                firmwareType,
                customResourceName,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<VCenterInfrastructureProfile>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VCenterInfrastructureProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(VCenterInfrastructureProfile)} does not support writing '{options.Format}' format.");
            }
        }

        VCenterInfrastructureProfile IPersistableModel<VCenterInfrastructureProfile>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<VCenterInfrastructureProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeVCenterInfrastructureProfile(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(VCenterInfrastructureProfile)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<VCenterInfrastructureProfile>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
