// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    /// <summary> Defines the different types of SCSI controllers. </summary>
    public readonly partial struct ScsiControllerType : IEquatable<ScsiControllerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ScsiControllerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ScsiControllerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LsilogicValue = "lsilogic";
        private const string BuslogicValue = "buslogic";
        private const string PvscsiValue = "pvscsi";
        private const string LsilogicsasValue = "lsilogicsas";

        /// <summary> lsilogic. </summary>
        public static ScsiControllerType Lsilogic { get; } = new ScsiControllerType(LsilogicValue);
        /// <summary> buslogic. </summary>
        public static ScsiControllerType Buslogic { get; } = new ScsiControllerType(BuslogicValue);
        /// <summary> pvscsi. </summary>
        public static ScsiControllerType Pvscsi { get; } = new ScsiControllerType(PvscsiValue);
        /// <summary> lsilogicsas. </summary>
        public static ScsiControllerType Lsilogicsas { get; } = new ScsiControllerType(LsilogicsasValue);
        /// <summary> Determines if two <see cref="ScsiControllerType"/> values are the same. </summary>
        public static bool operator ==(ScsiControllerType left, ScsiControllerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ScsiControllerType"/> values are not the same. </summary>
        public static bool operator !=(ScsiControllerType left, ScsiControllerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ScsiControllerType"/>. </summary>
        public static implicit operator ScsiControllerType(string value) => new ScsiControllerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ScsiControllerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ScsiControllerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
