// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    /// <summary> Defines the options for power on boot. </summary>
    public readonly partial struct PowerOnBootOption : IEquatable<PowerOnBootOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PowerOnBootOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PowerOnBootOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "enabled";
        private const string DisabledValue = "disabled";

        /// <summary> enabled. </summary>
        public static PowerOnBootOption Enabled { get; } = new PowerOnBootOption(EnabledValue);
        /// <summary> disabled. </summary>
        public static PowerOnBootOption Disabled { get; } = new PowerOnBootOption(DisabledValue);
        /// <summary> Determines if two <see cref="PowerOnBootOption"/> values are the same. </summary>
        public static bool operator ==(PowerOnBootOption left, PowerOnBootOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PowerOnBootOption"/> values are not the same. </summary>
        public static bool operator !=(PowerOnBootOption left, PowerOnBootOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PowerOnBootOption"/>. </summary>
        public static implicit operator PowerOnBootOption(string value) => new PowerOnBootOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PowerOnBootOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PowerOnBootOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
