// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    public partial class PlacementProfile : IUtf8JsonSerializable, IJsonModel<PlacementProfile>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PlacementProfile>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PlacementProfile>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PlacementProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PlacementProfile)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(ResourcePoolId))
            {
                writer.WritePropertyName("resourcePoolId"u8);
                writer.WriteStringValue(ResourcePoolId);
            }
            if (Optional.IsDefined(ClusterId))
            {
                writer.WritePropertyName("clusterId"u8);
                writer.WriteStringValue(ClusterId);
            }
            if (Optional.IsDefined(HostId))
            {
                writer.WritePropertyName("hostId"u8);
                writer.WriteStringValue(HostId);
            }
            if (Optional.IsDefined(DatastoreId))
            {
                writer.WritePropertyName("datastoreId"u8);
                writer.WriteStringValue(DatastoreId);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PlacementProfile IJsonModel<PlacementProfile>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PlacementProfile>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PlacementProfile)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePlacementProfile(document.RootElement, options);
        }

        internal static PlacementProfile DeserializePlacementProfile(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string resourcePoolId = default;
            string clusterId = default;
            string hostId = default;
            string datastoreId = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("resourcePoolId"u8))
                {
                    resourcePoolId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("clusterId"u8))
                {
                    clusterId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("hostId"u8))
                {
                    hostId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("datastoreId"u8))
                {
                    datastoreId = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PlacementProfile(resourcePoolId, clusterId, hostId, datastoreId, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<PlacementProfile>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PlacementProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(PlacementProfile)} does not support writing '{options.Format}' format.");
            }
        }

        PlacementProfile IPersistableModel<PlacementProfile>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PlacementProfile>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePlacementProfile(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PlacementProfile)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PlacementProfile>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
