// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.ConnectedVMwarevSphere.Models
{
    /// <summary> Defines the network interface ip settings. </summary>
    public partial class NicIPSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="NicIPSettings"/>. </summary>
        public NicIPSettings()
        {
            DnsServers = new ChangeTrackingList<string>();
            Gateway = new ChangeTrackingList<string>();
            IPAddressInfo = new ChangeTrackingList<NicIPAddressSettings>();
        }

        /// <summary> Initializes a new instance of <see cref="NicIPSettings"/>. </summary>
        /// <param name="allocationMethod"> Gets or sets the nic allocation method. </param>
        /// <param name="dnsServers"> Gets or sets the dns servers. </param>
        /// <param name="gateway"> Gets or sets the gateway. </param>
        /// <param name="ipAddress"> Gets or sets the ip address for the nic. </param>
        /// <param name="subnetMask"> Gets or sets the mask. </param>
        /// <param name="primaryWinsServer"> Gets or sets the primary server. </param>
        /// <param name="secondaryWinsServer"> Gets or sets the secondary server. </param>
        /// <param name="ipAddressInfo"> Gets or sets the IP address information being reported for this NIC. This contains the same IPv4 information above plus IPV6 information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal NicIPSettings(IPAddressAllocationMethod? allocationMethod, IList<string> dnsServers, IList<string> gateway, string ipAddress, string subnetMask, string primaryWinsServer, string secondaryWinsServer, IReadOnlyList<NicIPAddressSettings> ipAddressInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AllocationMethod = allocationMethod;
            DnsServers = dnsServers;
            Gateway = gateway;
            IPAddress = ipAddress;
            SubnetMask = subnetMask;
            PrimaryWinsServer = primaryWinsServer;
            SecondaryWinsServer = secondaryWinsServer;
            IPAddressInfo = ipAddressInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the nic allocation method. </summary>
        public IPAddressAllocationMethod? AllocationMethod { get; set; }
        /// <summary> Gets or sets the dns servers. </summary>
        public IList<string> DnsServers { get; }
        /// <summary> Gets or sets the gateway. </summary>
        public IList<string> Gateway { get; }
        /// <summary> Gets or sets the ip address for the nic. </summary>
        public string IPAddress { get; set; }
        /// <summary> Gets or sets the mask. </summary>
        public string SubnetMask { get; set; }
        /// <summary> Gets or sets the primary server. </summary>
        public string PrimaryWinsServer { get; }
        /// <summary> Gets or sets the secondary server. </summary>
        public string SecondaryWinsServer { get; }
        /// <summary> Gets or sets the IP address information being reported for this NIC. This contains the same IPv4 information above plus IPV6 information. </summary>
        public IReadOnlyList<NicIPAddressSettings> IPAddressInfo { get; }
    }
}
